/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.ImplementationError;

public class ViewsChangedIndication
extends CDOServerIndication {
    public ViewsChangedIndication(CDOServerProtocol protocol) {
        super(protocol, (short)4);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        byte kind = in.readByte();
        Session session = this.getSession();
        switch (kind) {
            case 4: {
                IView view = session.getView(viewID);
                if (view == null) break;
                view.close();
                break;
            }
            case 1: {
                session.openTransaction(viewID);
                break;
            }
            case 3: {
                session.openView(viewID);
                break;
            }
            case 2: {
                long timeStamp = in.readLong();
                session.openAudit(viewID, timeStamp);
                break;
            }
            default: {
                throw new ImplementationError("Invalid kind: " + kind);
            }
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeBoolean(true);
    }
}

