/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ResourceIDIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ResourceIDIndication.class);
    private CDOID id;

    public ResourceIDIndication(CDOServerProtocol protocol) {
        super(protocol, (short)5);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read viewID: {0}", new Object[]{viewID});
        }
        String path = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read path: {0}", new Object[]{path});
        }
        IView view = this.getSession().getView(viewID);
        this.id = view.getResourceID(path);
    }

    protected void responding(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing ID: {0}", new Object[]{this.id});
        }
        out.writeCDOID(this.id);
    }
}

