/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadChunkIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadChunkIndication.class);
    private CDOID id;
    private int version;
    private EStructuralFeature feature;
    private int fromIndex;
    private int toIndex;

    public LoadChunkIndication(CDOServerProtocol protocol) {
        super(protocol, (short)10);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read revision ID: {0}", new Object[]{this.id});
        }
        this.version = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read revision version: {0}", new Object[]{this.version});
        }
        EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
        int featureID = in.readInt();
        this.feature = eClass.getEStructuralFeature(featureID);
        if (TRACER.isEnabled()) {
            TRACER.format("Read feature: {0}", new Object[]{this.feature});
        }
        this.fromIndex = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read fromIndex: {0}", new Object[]{this.fromIndex});
        }
        this.toIndex = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read toIndex: {0}", new Object[]{this.toIndex});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalCDORevision revision = this.getRepository().getRevisionManager().getRevisionByVersion(this.id, 0, this.version);
        this.getRepository().getRevisionManager().ensureChunk(revision, this.feature, this.fromIndex, this.toIndex + 1);
        CDOType type = CDOModelUtil.getType((EStructuralFeature)this.feature);
        CDOList list = revision.getList(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            type.writeValue(out, list.get(i));
            ++i;
        }
    }
}

