/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LogicalOperator implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR"),
    IFTHEN(3, "IFTHEN", "IFTHEN"),
    NOTBOTH(4, "NOTBOTH", "NOTBOTH");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    public static final int IFTHEN_VALUE = 3;
    public static final int NOTBOTH_VALUE = 4;
    private static final LogicalOperator[] VALUES_ARRAY;
    public static final List<LogicalOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogicalOperator[]{AND, OR, XOR, IFTHEN, NOTBOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogicalOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperator get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
            case 3: {
                return IFTHEN;
            }
            case 4: {
                return NOTBOTH;
            }
        }
        return null;
    }

    private LogicalOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

