/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.notation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mdht.uml.common.util.MultiplicityElementUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class PropertyNotationUtil {
    public static final String UNDEFINED_TYPE_NAME = "<Undefined>";

    public static List<Property> getSubsettablesProperties(Property property) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (NamedElement element : property.getClass_().getMembers()) {
            if (!(element instanceof Property)) continue;
            boolean isValid = true;
            Property subsettableProperty = (Property)element;
            if (subsettableProperty.equals(property)) {
                isValid = false;
            }
            if (property.getType() != null && subsettableProperty.getType() != null) {
                if (!property.getType().conformsTo(subsettableProperty.getType())) {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
            if (subsettableProperty.getUpper() != -1 && property.getUpper() > subsettableProperty.getUpper()) {
                isValid = false;
            }
            if (!isValid) continue;
            list.add(subsettableProperty);
        }
        return list;
    }

    public static List<Property> getRedefinableProperties(Property property) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (NamedElement element : property.getClass_().getMembers()) {
            Property redefinableProperty;
            if (!(element instanceof Property) || (redefinableProperty = (Property)element).equals(property)) continue;
            list.add(redefinableProperty);
        }
        return list;
    }

    public static String getLabel(Property property) {
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        if (property.isDerived()) {
            buffer.append("/");
        }
        buffer.append(" ");
        buffer.append(property.getName());
        if (property.getType() != null) {
            buffer.append(": " + property.getType().getName());
        } else {
            buffer.append(": <Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if (property.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(property.getDefault());
        }
        if (!(modifiers = PropertyNotationUtil.getModifiersAsString(property, false)).equals("")) {
            buffer.append(" {");
            buffer.append(modifiers);
            buffer.append("}");
        }
        return buffer.toString();
    }

    public static String getCustomLabel(Property property, int style) {
        boolean multiLine;
        String modifiers;
        boolean showBrackets;
        String multiplicity;
        StringBuffer buffer = new StringBuffer();
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        }
        if ((style & 4) != 0 && property.isDerived()) {
            buffer.append("/");
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(property.getName());
        }
        if ((style & 0x10) != 0) {
            if (property.getType() != null) {
                buffer.append(" : " + property.getType().getName());
            } else {
                buffer.append(" : <Undefined>");
            }
        }
        if ((style & 0x20) != 0 && !(multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property)).trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if ((style & 0x40) != 0 && property.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(property.getDefault());
        }
        boolean bl = showBrackets = buffer.length() > 0;
        if ((style & 0x80) != 0 && !(modifiers = PropertyNotationUtil.getModifiersAsString(property, multiLine = (style & 0x100000) != 0)).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            buffer.append(showBrackets ? " {" : "");
            buffer.append(modifiers);
            buffer.append(showBrackets ? "}" : "");
        }
        return buffer.toString();
    }

    protected static String getModifiersAsString(Property property, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? "\n" : "";
        if (property.isReadOnly()) {
            buffer.append("readOnly");
            needsComma = true;
        }
        if (property.isDerivedUnion()) {
            if (needsComma) {
                buffer.append(",");
                buffer.append(NL);
            }
            buffer.append("union");
            needsComma = true;
        }
        if (!property.isOrdered() && property.upperBound() != 1 && property.upperBound() != 0) {
            if (needsComma) {
                buffer.append(",");
                buffer.append(NL);
            }
            buffer.append("unordered");
            needsComma = true;
        }
        if (property.isUnique() && property.getUpper() > 1) {
            if (needsComma) {
                buffer.append(",");
                buffer.append(NL);
            }
            buffer.append("unique");
            needsComma = true;
        }
        for (Property redefinedProperty : property.getRedefinedProperties()) {
            if (redefinedProperty.eIsProxy()) continue;
            if (needsComma) {
                buffer.append(", ");
                buffer.append(NL);
            }
            needsComma = true;
            if (redefinedProperty.getName().equals(property.getName())) {
                buffer.append("redefined");
                continue;
            }
            buffer.append("redefines ");
            buffer.append(redefinedProperty.getName());
        }
        for (Property current : property.getSubsettedProperties()) {
            if (current.eIsProxy()) continue;
            if (needsComma) {
                buffer.append(", ");
                buffer.append(NL);
            }
            buffer.append("subsets ");
            buffer.append(current.getName());
            needsComma = true;
        }
        return buffer.toString();
    }
}

