/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.CDAValueUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.GenerateCDADataHandler;
import org.eclipse.mdht.cda.xml.ui.handlers.MatchEncounterBy;
import org.eclipse.mdht.cda.xml.ui.handlers.SectionSwitch;
import org.eclipse.mdht.cda.xml.ui.handlers.SheetHeaderUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.SpreadsheetSerializer;
import org.eclipse.mdht.cda.xml.ui.internal.Logger;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.ServiceEvent;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.Supply;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.openhealthtools.mdht.uml.cda.consol.AssessmentScaleObservation;
import org.openhealthtools.mdht.uml.cda.consol.CognitiveStatusResultOrganizer;
import org.openhealthtools.mdht.uml.cda.consol.ConsolPackage;
import org.openhealthtools.mdht.uml.cda.consol.EncountersSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.FunctionalStatusSection;
import org.openhealthtools.mdht.uml.cda.consol.HealthConcernAct;
import org.openhealthtools.mdht.uml.cda.consol.HealthConcernsSection;
import org.openhealthtools.mdht.uml.cda.consol.HealthStatusObservation2;
import org.openhealthtools.mdht.uml.cda.consol.InterventionsSection2;
import org.openhealthtools.mdht.uml.cda.consol.NonMedicinalSupplyActivity;
import org.openhealthtools.mdht.uml.cda.consol.NutritionRecommendation;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareActivityAct;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareActivityEncounter;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareActivityObservation;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareActivitySubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareActivitySupply;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfCareSection;
import org.openhealthtools.mdht.uml.cda.consol.PlanOfTreatmentSection2;
import org.openhealthtools.mdht.uml.cda.consol.PlannedInterventionAct;
import org.openhealthtools.mdht.uml.cda.consol.util.ConsolSwitch;

class ProcessSectionSwitch
extends ConsolSwitch<Boolean> {
    private String splitOption;
    private CDAUtil.Query query;
    private SXSSFWorkbook wb;
    private CDAValueUtil.DocumentMetadata documentMetadata;
    private PatientRole patientRole;
    private ServiceEvent serviceEvent;
    private List<Encounter> encounters;
    private IFile file;
    private GenerateCDADataHandler currentHandler;
    private boolean skipMultipleSheetProcessing = false;
    static HashMap<String, EClass> codeToSection = new HashMap();

    public ProcessSectionSwitch(String splitOption, CDAUtil.Query query, SXSSFWorkbook wb, CDAValueUtil.DocumentMetadata documentMetadata, PatientRole patientRole, ServiceEvent serviceEvent, List<Encounter> encounters, IFile file, GenerateCDADataHandler currentHandler) {
        this.splitOption = splitOption;
        this.query = query;
        this.wb = wb;
        this.documentMetadata = documentMetadata;
        this.patientRole = patientRole;
        this.serviceEvent = serviceEvent;
        this.encounters = encounters;
        this.file = file;
        this.currentHandler = currentHandler;
        if (System.getProperty("org.eclipse.mdht.cda.xls.skip.multipleSheets") != null) {
            this.skipMultipleSheetProcessing = true;
        }
    }

    public Boolean caseFunctionalStatusSection(FunctionalStatusSection section) {
        int offset;
        Row row;
        int offset2;
        Row row1;
        SXSSFSheet sheet;
        String sheetIndex;
        if (this.skipMultipleSheetProcessing) {
            return Boolean.TRUE;
        }
        this.processClinicalStatements((Section)section);
        for (AssessmentScaleObservation observation : section.getAssessmentScaleObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getAssessmentScaleObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getAssessmentScaleObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (AssessmentScaleObservation observation : section.getNumberOfPressureUlcersObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getNumberOfPressureUlcersObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getNumberOfPressureUlcersObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (AssessmentScaleObservation observation : section.getCognitiveStatusProblemObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getCognitiveStatusProblemObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getCognitiveStatusProblemObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, false, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (CognitiveStatusResultOrganizer organizer : section.getCognitiveStatusResultOrganizers()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getCognitiveStatusResultOrganizer().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getCognitiveStatusResultOrganizer()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createProcedureHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Organizer)organizer, this.encounters);
            offset = SpreadsheetSerializer.serializeOrganizer(row, offset, (Organizer)organizer, false, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, organizer.getSection(), this.file.getName());
        }
        for (AssessmentScaleObservation observation : section.getFunctionalStatusProblemObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getFunctionalStatusProblemObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getFunctionalStatusProblemObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (AssessmentScaleObservation observation : section.getFunctionalStatusResultObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getFunctionalStatusResultObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getFunctionalStatusResultObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (CognitiveStatusResultOrganizer organizer : section.getFunctionalStatusResultOrganizers()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getFunctionalStatusResultOrganizer().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getFunctionalStatusResultOrganizer()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createProcedureHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Organizer)organizer, this.encounters);
            offset = SpreadsheetSerializer.serializeOrganizer(row, offset, (Organizer)organizer, false, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, organizer.getSection(), this.file.getName());
        }
        for (AssessmentScaleObservation observation : section.getHighestPressureUlcerStages()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getHighestPressureUlcerStage().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getHighestPressureUlcerStage()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (NonMedicinalSupplyActivity supply : section.getNonMedicinalSupplyActivities()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getNonMedicinalSupplyActivity().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getNonMedicinalSupplyActivity()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset2, "Plan Of Care Activity Substance Administration");
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Supply)supply, this.encounters);
            offset = SpreadsheetSerializer.serializeSupply(row, offset, (Supply)supply);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, supply.getSection(), this.file.getName());
        }
        for (AssessmentScaleObservation observation : section.getPressureUlcerObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPressureUlcerObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPressureUlcerObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        return Boolean.TRUE;
    }

    public Boolean caseInterventionsSection2(InterventionsSection2 section) {
        int offset;
        Row row;
        int offset2;
        Row row1;
        SXSSFSheet sheet;
        String sheetIndex;
        if (this.skipMultipleSheetProcessing) {
            return Boolean.TRUE;
        }
        this.processClinicalStatements((Section)section);
        for (PlannedInterventionAct act : section.getPlannedInterventionActs()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlannedInterventionAct().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlannedInterventionAct()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createProcedureHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)act, this.encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityAct(row, offset, (Act)act, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, act.getSection(), this.file.getName());
        }
        for (PlannedInterventionAct act : section.getHandoffCommunications()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getHandoffCommunicationParticipants().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getHandoffCommunicationParticipants()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createProcedureHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)act, this.encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityAct(row, offset, (Act)act, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, act.getSection(), this.file.getName());
        }
        return Boolean.TRUE;
    }

    public Boolean caseHealthConcernsSection(HealthConcernsSection section) {
        int offset;
        Row row;
        int offset2;
        Row row1;
        SXSSFSheet sheet;
        String sheetIndex;
        if (this.skipMultipleSheetProcessing) {
            return Boolean.TRUE;
        }
        this.processClinicalStatements((Section)section);
        for (HealthConcernAct act : section.getHealthConcernActs()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getHealthConcernAct().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getHealthConcernAct()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createProcedureHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)act, this.encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityAct(row, offset, (Act)act, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, act.getSection(), this.file.getName());
        }
        for (HealthStatusObservation2 observation : section.getHealthStatusObservation2s()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getHealthStatusObservation2().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivityObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createObservationHeaderWithClinicalNotes(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        return Boolean.TRUE;
    }

    private void processClinicalStatements(Section section) {
        String sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(section.eClass().getClassifierID()), GenerateCDADataHandler.sheetName(section.eClass()), this.splitOption);
        SXSSFSheet sheet = this.wb.getSheet(sheetIndex);
        if (section.getEntries().isEmpty()) {
            if (sheet.getPhysicalNumberOfRows() == 0) {
                Row row1 = null;
                Row row2 = sheet.createRow(0);
                int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
                offset = SheetHeaderUtil.createClinicalStatmentHeader(row1, row2, offset);
            }
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, null, this.encounters);
            offset += 11;
            offset = SpreadsheetSerializer.serializeSectionAndFileName(row, offset, section, this.file.getName());
            offset = SpreadsheetSerializer.serializeStrucDocText(row, offset, section.getText());
        }
        for (Entry entry : section.getEntries()) {
            if (sheet.getPhysicalNumberOfRows() == 0) {
                Row row1 = null;
                Row row2 = sheet.createRow(0);
                int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
                offset = SheetHeaderUtil.createClinicalStatmentHeader(row1, row2, offset);
            }
            if (entry.getAct() != null) {
                Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, entry.getAct(), this.encounters);
                offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, entry.getAct());
                SpreadsheetSerializer.serializeSectionAndFileName(row, offset, entry.getAct().getSection(), this.file.getName());
            }
            if (entry.getObservation() != null) {
                Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, entry.getObservation(), this.encounters);
                offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, entry.getObservation());
                SpreadsheetSerializer.serializeSectionAndFileName(row, offset, entry.getObservation().getSection(), this.file.getName());
            }
            if (entry.getProcedure() != null) {
                Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, entry.getProcedure(), this.encounters);
                offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, entry.getProcedure());
                SpreadsheetSerializer.serializeSectionAndFileName(row, offset, entry.getProcedure().getSection(), this.file.getName());
            }
            if (entry.getOrganizer() == null) continue;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, entry.getOrganizer(), this.encounters);
            offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, entry.getOrganizer());
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, entry.getOrganizer().getSection(), this.file.getName());
        }
    }

    public Boolean casePlanOfCareSection(PlanOfCareSection section) {
        int offset;
        Row row;
        int offset2;
        Row row1;
        SXSSFSheet sheet;
        String sheetIndex;
        if (this.skipMultipleSheetProcessing) {
            return Boolean.TRUE;
        }
        this.processClinicalStatements((Section)section);
        for (PlanOfCareActivityAct act : section.getPlanOfCareActivityActs()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlanOfCareActivityAct().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivityAct()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createProcedureHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)act, this.encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityAct(row, offset, (Act)act, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, act.getSection(), this.file.getName());
        }
        for (PlanOfCareActivityEncounter encounter : section.getPlanOfCareActivityEncounters()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlanOfCareActivityEncounter().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivityEncounter()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createEncounterHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, (Encounter)encounter, MatchEncounterBy.BYID);
            offset = SpreadsheetSerializer.serializeEncounter(row, offset, (Encounter)encounter);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, encounter.getSection(), this.file.getName());
        }
        for (PlanOfCareActivityObservation observation : section.getPlanOfCareActivityObservations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlanOfCareActivityObservation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivityObservation()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createPlanOfCareActivityObservationHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, (Observation)observation, true, false, false);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.file.getName());
        }
        for (PlanOfCareActivityAct act : section.getPlanOfCareActivityProcedures()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlanOfCareActivityProcedure().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivityProcedure()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createEncounterHeader(row1, row2, offset2);
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Procedure)act, this.encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityProcedure(row, offset, (Procedure)act, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, act.getSection(), this.file.getName());
        }
        for (PlanOfCareActivitySubstanceAdministration planOfCareActivitySubstanceAdministration : section.getPlanOfCareActivitySubstanceAdministrations()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlanOfCareActivitySubstanceAdministration().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivitySubstanceAdministration()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset2, "Plan Of Care Activity Substance Administration");
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (SubstanceAdministration)planOfCareActivitySubstanceAdministration, this.encounters);
            offset = SpreadsheetSerializer.serializeSubstanceAdministration(row, offset, (SubstanceAdministration)planOfCareActivitySubstanceAdministration, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, planOfCareActivitySubstanceAdministration.getSection(), this.file.getName());
        }
        for (PlanOfCareActivitySupply supply : section.getPlanOfCareActivitySupplies()) {
            sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getPlanOfCareActivitySupply().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getPlanOfCareActivitySupply()), this.splitOption);
            sheet = this.wb.getSheet(sheetIndex);
            if (sheet.getPhysicalNumberOfRows() == 0) {
                row1 = null;
                Row row2 = sheet.createRow(0);
                offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                offset2 = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset2, "Plan Of Care Activity Substance Administration");
            }
            row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Supply)supply, this.encounters);
            offset = SpreadsheetSerializer.serializeSupply(row, offset, (Supply)supply);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, supply.getSection(), this.file.getName());
        }
        if (section instanceof PlanOfTreatmentSection2) {
            for (NutritionRecommendation nutritionRecommendation : ((PlanOfTreatmentSection2)section).getNutritionRecommendations()) {
                sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(String.valueOf(section.eClass().getClassifierID()) + "." + String.valueOf(ConsolPackage.eINSTANCE.getNutritionRecommendation().getClassifierID())), GenerateCDADataHandler.sheetName(ConsolPackage.eINSTANCE.getNutritionRecommendation()), this.splitOption);
                sheet = this.wb.getSheet(sheetIndex);
                if (sheet.getPhysicalNumberOfRows() == 0) {
                    row1 = null;
                    Row row2 = sheet.createRow(0);
                    offset2 = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                    offset2 = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset2);
                    offset2 = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset2, "Plan Of Care Activity Substance Administration");
                }
                row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)nutritionRecommendation, this.encounters);
                offset = this.serializeNutritionRecommendation(row, offset, nutritionRecommendation);
                SpreadsheetSerializer.serializeSectionAndFileName(row, offset, nutritionRecommendation.getSection(), this.file.getName());
            }
        }
        return Boolean.TRUE;
    }

    private int serializeNutritionRecommendation(Row row, int offset, NutritionRecommendation nutritionRecommendation) {
        return offset;
    }

    public Boolean caseSection(Section section) {
        if (this.skipMultipleSheetProcessing) {
            return Boolean.TRUE;
        }
        String sheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(section.eClass().getClassifierID()), GenerateCDADataHandler.sheetName(section.eClass()), this.splitOption);
        if (!(section instanceof EncountersSectionEntriesOptional)) {
            SectionSwitch sectionSwitch = new SectionSwitch(this.query, (Sheet)this.wb.getSheet(sheetIndex), this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, this.file.getName());
            sectionSwitch.doSwitch((EObject)section);
            try {
                this.wb.getSheet(sheetIndex).flushRows();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.currentHandler.shouldCountSection(section)) {
            this.currentHandler.getSectionHash(section.getClinicalDocument().eClass().getClassifierID(), sheetIndex, this.splitOption).add(this.file);
        }
        return Boolean.TRUE;
    }

    public Boolean defaultCase(EObject object) {
        Section section = (Section)object;
        StringBuffer sb = new StringBuffer();
        sb.append("UnIdentified Section  in " + this.file.getName());
        sb.append("Section title is ").append(section.getTitle().getText());
        for (II ii : section.getTemplateIds()) {
            sb.append(ii.getRoot()).append(StringUtils.isEmpty((String)ii.getExtension()) ? "" : " : " + ii.getExtension());
        }
        Logger.log(4, sb.toString());
        boolean processed = false;
        if (section.getCode() != null && !StringUtils.isEmpty((String)section.getCode().getCode())) {
            String code = section.getCode().getCode();
            if (ProcessSectionSwitch.getCodeToSection().containsKey(code)) {
                Section newSection = (Section)EcoreUtil.create((EClass)ProcessSectionSwitch.getCodeToSection().get(code));
                newSection.setText(section.getText());
                newSection.getEntries().addAll((Collection)section.getEntries());
                String secondChanceSheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(newSection.eClass().getClassifierID()), GenerateCDADataHandler.sheetName(newSection.eClass()), this.splitOption);
                SectionSwitch secondChanceSwitch = new SectionSwitch(this.query, (Sheet)this.wb.getSheet(secondChanceSheetIndex), this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, this.file.getName());
                secondChanceSwitch.doSwitch((EObject)newSection);
                if (this.currentHandler.shouldCountSection(newSection)) {
                    this.currentHandler.getSectionHash(section.getClinicalDocument().eClass().getClassifierID(), secondChanceSheetIndex, this.splitOption).add(this.file);
                }
                processed = true;
            }
        }
        if (!processed) {
            String secondChanceSheetIndex = this.currentHandler.getSheet(section.getClinicalDocument().eClass(), String.valueOf(section.eClass().getClassifierID()), GenerateCDADataHandler.sheetName(section.eClass()), this.splitOption);
            SectionSwitch secondChanceSwitch = new SectionSwitch(this.query, (Sheet)this.wb.getSheet(secondChanceSheetIndex), this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, this.file.getName());
            secondChanceSwitch.setFirstpass(false);
            secondChanceSwitch.doSwitch((EObject)section);
            if (this.currentHandler.shouldCountSection(section)) {
                this.currentHandler.getSectionHash(section.getClinicalDocument().eClass().getClassifierID(), secondChanceSheetIndex, this.splitOption).add(this.file);
            }
        }
        return Boolean.FALSE;
    }

    public static HashMap<String, EClass> getCodeToSection() {
        if (codeToSection.isEmpty()) {
            for (EClassifier consolPackageClassifier : ConsolPackage.eINSTANCE.getEClassifiers()) {
                EAnnotation annotation;
                String code;
                if (!CDAPackage.eINSTANCE.getSection().isSuperTypeOf(CDAPackage.eINSTANCE.getSection()) || codeToSection.containsKey(code = (String)(annotation = consolPackageClassifier.getEAnnotation("http://www.openhealthtools.org/mdht/uml/cda/annotation")).getDetails().get((Object)"code.code"))) continue;
                codeToSection.put(code, (EClass)consolPackageClassifier);
            }
        }
        return codeToSection;
    }
}

