/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation.table;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import traceability.presentation.TraceabilityEditor;
import traceability.presentation.Tracing;
import traceability.presentation.table.GroupItem;
import traceability.presentation.table.TableCellDifference;
import traceability.presentation.table.TraceabilityViewer;
import traceability.presentation.table.TraceabilityViewerLabelProvider;

public class TraceabilityViewerContentProvider
implements ITreeContentProvider {
    Map<Object, Object> parentOf = new HashMap<Object, Object>();
    List<Object> allElements = new ArrayList<Object>();
    Map<Object, GroupItem> groupOf = new HashMap<Object, GroupItem>();
    protected List<Object> parents;
    private TraceabilityViewer myXviewer;

    public TraceabilityViewerContentProvider(TraceabilityViewer myXviewer) {
        this.myXviewer = myXviewer;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (this.parents != null) {
            return this.parents.toArray();
        }
        this.parents = new ArrayList<Object>();
        if (!(inputElement instanceof Tracing)) {
            return this.parents.toArray();
        }
        this.myXviewer.tracing = (Tracing)inputElement;
        this.parents.addAll(this.myXviewer.tracing.rows);
        Set<EObject> tableTraced = this.getTableTraced();
        int originalSize = this.parents.size();
        long started = new Date().getTime();
        this.filterRows();
        long ended = new Date().getTime();
        Set<EObject> filteredTableTraced = this.getTableTraced();
        System.out.println("filter took " + (ended - started));
        int filteredSize = this.parents.size();
        this.organizeTree();
        if (!this.myXviewer.traceabilityEditor.traceabilityFilters_TREE) {
            this.parents = this.flattenTree(this.parents);
        }
        Set<EObject> treeTableTraced = this.getTableTraced();
        int treeSize = this.parents.size();
        int childrenNumber = this.getChildrenCount(this.parents);
        int treeParents = this.getTreeParentsCount(this.parents);
        for (EObject eObject : this.myXviewer.tracing.traced) {
            if (tableTraced.contains(eObject)) continue;
            System.err.println("Not traced:" + eObject);
        }
        System.out.println("traced=" + this.myXviewer.tracing.traced.size() + " original=" + originalSize + "/" + tableTraced.size() + " filtered=" + filteredSize + "/" + filteredTableTraced.size() + " tree=" + (treeSize + childrenNumber) + "/" + treeTableTraced.size() + " treeparents=" + treeParents);
        this.populateLookupMaps(this.parents);
        return this.parents.toArray();
    }

    private int getTreeParentsCount(List<Object> objects) {
        int result = 0;
        for (Object object : objects) {
            if (!(object instanceof GroupItem)) continue;
            GroupItem groupItem = (GroupItem)object;
            if (groupItem.childrenOf.size() != 0) {
                ++result;
            }
            result += this.getTreeParentsCount(groupItem.childrenOf);
        }
        return result;
    }

    private int getChildrenCount(List<Object> objects) {
        int result = 0;
        for (Object object : objects) {
            if (!(object instanceof GroupItem)) continue;
            GroupItem groupItem = (GroupItem)object;
            result += groupItem.childrenOf.size();
            result += this.getChildrenCount(groupItem.childrenOf);
        }
        return result;
    }

    private List<Object> flattenTree(List<Object> parents) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object parent : parents) {
            result.add(parent);
            if (!(parent instanceof GroupItem)) continue;
            GroupItem groupItem = (GroupItem)parent;
            result.addAll(this.flattenTree(groupItem.childrenOf));
            groupItem.childrenOf.clear();
        }
        return result;
    }

    private Set<EObject> getTableTraced() {
        HashSet<EObject> tableTraced = new HashSet<EObject>();
        for (Object parent : this.parents) {
            if (!(TraceabilityViewer.getRedirectedElement(parent) instanceof EObject)) continue;
            EObject eObject = (EObject)TraceabilityViewer.getRedirectedElement(parent);
            while (eObject != null) {
                tableTraced.add(eObject);
                eObject = this.myXviewer.tracing.backward.get(eObject);
            }
            eObject = (EObject)TraceabilityViewer.getRedirectedElement(parent);
            while (eObject != null) {
                tableTraced.add(eObject);
                eObject = this.myXviewer.tracing.forward.get(eObject);
            }
        }
        return tableTraced;
    }

    private void filterRows() {
        HashSet allRows = new HashSet();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : this.parents) {
            if (!this.myXviewer.tracing.diffOfElement.isEmpty() && !this.myXviewer.traceabilityEditor.traceabilityFilters_NEQ && !this.myXviewer.traceabilityEditor.traceabilityFilters_EQ && !this.myXviewer.traceabilityEditor.traceabilityFilters_PLUS && !this.myXviewer.traceabilityEditor.traceabilityFilters_MINUS) continue;
            boolean hasUnequal = false;
            boolean hasEqual = false;
            boolean hasPlus = false;
            boolean hasMinus = false;
            boolean hasError = false;
            boolean matchText = false;
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (XViewerColumn xCol : this.myXviewer.getCustomizeMgr().getCurrentTableColumns()) {
                String text;
                List<TableCellDifference> cellDiffs;
                if (!xCol.isShow() && this.myXviewer.traceabilityEditor.excludedColsFromDiffing().contains(xCol)) continue;
                Object cellData = this.myXviewer.getCellData(this.myXviewer.traceabilityEditor.getColForDiffing(xCol), element);
                if (xCol.isShow()) {
                    rowData.add(cellData);
                }
                hasError |= cellData != null && this.myXviewer.traceabilityEditor.isErrorCol(xCol);
                if (xCol.isShow() && (cellDiffs = ((TraceabilityViewerLabelProvider)this.myXviewer.getLabelProvider()).getTableCellDifferences(element, xCol)) != null && cellDiffs.size() != 0) {
                    if (cellDiffs.size() >= 2 && TraceabilityViewerLabelProvider.getValueSet(cellDiffs).size() == 1) {
                        hasEqual = true;
                    } else {
                        String diff = cellDiffs.get(0).getDiffText();
                        if ("+".equals(diff) && !"?".equals(cellDiffs.get(0).getCellText())) {
                            hasPlus = true;
                        }
                        if ("-".equals(diff) && !"?".equals(cellDiffs.get(0).getCellText())) {
                            hasMinus = true;
                        }
                        if (TraceabilityEditor.DIFF_UNEQUAL.equals(diff)) {
                            hasUnequal = true;
                        }
                    }
                }
                matchText |= TraceabilityViewer.findText(text = ((TraceabilityViewerLabelProvider)this.myXviewer.getLabelProvider()).getColumnTextOriginal(element, xCol, -1), this.myXviewer.filterText, this.myXviewer.regex) != null;
            }
            if (!this.myXviewer.tracing.diffOfElement.isEmpty() && (!hasUnequal || !this.myXviewer.traceabilityEditor.traceabilityFilters_NEQ) && (!hasEqual || !this.myXviewer.traceabilityEditor.traceabilityFilters_EQ) && (!hasPlus || !this.myXviewer.traceabilityEditor.traceabilityFilters_PLUS) && (!hasMinus || !this.myXviewer.traceabilityEditor.traceabilityFilters_MINUS) || !"".equals(this.myXviewer.filterText) && !matchText || this.myXviewer.traceabilityEditor.traceabilityFilters_ERR && !hasError || !allRows.add(rowData)) continue;
            result.add(element);
        }
        this.parents = result;
    }

    protected void organizeTree() {
    }

    private void populateLookupMaps(List<Object> list) {
        this.allElements.addAll(list);
        for (Object object : list) {
            if (!(object instanceof GroupItem)) continue;
            GroupItem groupItem = (GroupItem)object;
            this.groupOf.put(groupItem.element, groupItem);
            for (Object child : groupItem.childrenOf) {
                this.parentOf.put(child, object);
            }
            this.populateLookupMaps(groupItem.childrenOf);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Resource) {
            return this.getElements(parentElement);
        }
        if (parentElement instanceof GroupItem) {
            return ((GroupItem)parentElement).childrenOf.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return this.parentOf.get(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

