/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.saveable;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mdht.uml.common.ui.internal.Logger;
import org.eclipse.mdht.uml.common.ui.internal.l10n.Messages;
import org.eclipse.mdht.uml.common.ui.saveable.ModelDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.Saveable;

public class ModelManager {
    private static ModelManager Manager = new ModelManager();
    private ListenerList listeners = new ListenerList();
    private Map<URI, ModelDocument> uriToDocumentMap = new HashMap<URI, ModelDocument>();
    private List<Resource> changedResources = new Vector<Resource>();
    private List<Resource> removedResources = new Vector<Resource>();
    private List<Resource> savedResources = new Vector<Resource>();
    private Shell shell;
    private ResourceSetListener resourceLoadListener = new ResourceSetListenerImpl(NotificationFilter.RESOURCE_LOADED.or(NotificationFilter.RESOURCE_UNLOADED)){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            for (Notification notification : event.getNotifications()) {
                Resource resource = (Resource)notification.getNotifier();
                if (NotificationFilter.RESOURCE_LOADED.matches(notification) && ModelManager.this.isManageable(resource)) {
                    ModelManager.this.manage(resource);
                    continue;
                }
                if (!NotificationFilter.RESOURCE_UNLOADED.matches(notification)) continue;
                ModelDocument modelDocument = (ModelDocument)((Object)ModelManager.this.uriToDocumentMap.get(resource.getURI()));
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ModelManager.this.removedResources.clear();
            ModelManager.this.changedResources.clear();
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072)) {
                            Resource resource;
                            ModelDocument modelDocument = ModelManager.this.getModelDocument(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true));
                            Resource resource2 = resource = modelDocument != null ? modelDocument.getResource() : null;
                            if (resource != null) {
                                if (delta.getKind() == 2) {
                                    ModelManager.this.removedResources.add(resource);
                                } else if (!ModelManager.this.savedResources.remove(resource)) {
                                    ModelManager.this.changedResources.add(resource);
                                }
                            }
                        }
                        return true;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!ModelManager.this.removedResources.isEmpty() && ModelManager.this.shell != null) {
                    ModelManager.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListIterator resourceIterator = ModelManager.this.removedResources.listIterator();
                            while (resourceIterator.hasNext()) {
                                Resource resource = (Resource)resourceIterator.next();
                                if (ModelManager.this.isDirty(resource) && !ModelManager.this.handleDirtyConflict(resource)) continue;
                                resourceIterator.remove();
                                resource.unload();
                            }
                        }
                    });
                }
                if (!ModelManager.this.changedResources.isEmpty() && ModelManager.this.shell != null) {
                    ModelManager.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (Resource resource : ModelManager.this.changedResources) {
                                if (ModelManager.this.isDirty(resource) && !ModelManager.this.handleDirtyConflict(resource)) continue;
                                resource.unload();
                                try {
                                    ModelDocument modelDocument = ModelManager.this.getModelDocument(resource);
                                    if (modelDocument != null) {
                                        modelDocument.setDirty(false);
                                    }
                                    resource.load(Collections.EMPTY_MAP);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                Logger.logException(exception);
            }
        }
    };

    public static ModelManager getManager() {
        return Manager;
    }

    private ModelManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void manage(TransactionalEditingDomain editingDomain) {
        editingDomain.addResourceSetListener(this.resourceLoadListener);
        for (Resource resource : editingDomain.getResourceSet().getResources()) {
            if (!this.isManageable(resource) || this.uriToDocumentMap.get(resource.getURI()) != null) continue;
            this.manage(resource);
        }
    }

    public boolean isManageable(Resource resource) {
        URI uri = resource.getURI();
        return uri.isPlatformResource() && "uml".equals(uri.fileExtension());
    }

    public ModelDocument manage(Resource resource) {
        ModelDocument saveable = this.getModelDocument(resource);
        if (saveable == null) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
            saveable = new ModelDocument(resource, editingDomain);
            this.uriToDocumentMap.put(resource.getURI(), saveable);
        }
        return saveable;
    }

    public EditingDomain getEditingDomain(IFile file) {
        ModelDocument doc = this.getModelDocument(file);
        if (doc != null) {
            return doc.getEditingDomain();
        }
        return null;
    }

    public ModelDocument getModelDocument(Resource resource) {
        if (resource != null) {
            return this.uriToDocumentMap.get(resource.getURI());
        }
        return null;
    }

    public ModelDocument getModelDocument(URI uri) {
        if (uri != null) {
            return this.uriToDocumentMap.get(uri);
        }
        return null;
    }

    public ModelDocument getModelDocument(IFile file) {
        return this.uriToDocumentMap.get(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
    }

    public Resource getResource(IFile file) {
        ModelDocument saveable = this.uriToDocumentMap.get(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        if (saveable != null) {
            return saveable.getResource();
        }
        return null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void firePropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        if (!this.listeners.isEmpty()) {
            PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
            Object[] list = this.listeners.getListeners();
            int i = 0;
            while (i < list.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)list[i];
                l.propertyChange(event);
                ++i;
            }
        }
    }

    public boolean isDirty(Resource resource) {
        return resource.isModified();
    }

    public Collection<ModelDocument> getDocuments() {
        return this.uriToDocumentMap.values();
    }

    public Saveable[] getSaveables() {
        Collection<ModelDocument> saveables = this.uriToDocumentMap.values();
        Saveable[] array = new Saveable[saveables.size()];
        saveables.toArray(array);
        return array;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }

    public Collection<Resource> getChangedResources() {
        return this.changedResources;
    }

    public Collection<Resource> getSavedResources() {
        return this.savedResources;
    }

    protected boolean handleDirtyConflict(Resource resource) {
        return MessageDialog.openQuestion((Shell)this.shell, (String)Messages.FileConflict_label, (String)Messages.FileConflictWarning);
    }
}

