/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.cda.ui.properties.ValidationSection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class PropertySection
extends ValidationSection {
    private Button mandatoryButton;
    private boolean mandatoryModified = false;

    @Override
    protected Stereotype getValidationStereotype() {
        String qname = "CDA::PropertyValidation";
        Stereotype stereotype = this.modelElement.getApplicableStereotype(qname);
        return stereotype;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Property));
        this.modelElement = (Property)element;
    }

    @Override
    protected void modifyFields() {
        super.modifyFields();
        if (!this.mandatoryModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype stereotype = PropertySection.this.getValidationStereotype();
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!PropertySection.this.modelElement.isStereotypeApplied(stereotype)) {
                        PropertySection.this.modelElement.applyStereotype(stereotype);
                    }
                    if (!PropertySection.this.mandatoryModified) {
                        return Status.CANCEL_STATUS;
                    }
                    PropertySection.this.mandatoryModified = false;
                    this.setLabel("Set Validation Mandatory");
                    PropertySection.this.modelElement.setValue(stereotype, "mandatory", (Object)PropertySection.this.mandatoryButton.getSelection());
                    PropertySection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Group composite = this.getWidgetFactory().createGroup(parent, "Property Validation (multiplicty, type)");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        this.addValidationControls((Composite)composite, 0, 1);
        this.addScope((Composite)composite, 0, 1);
        FormData data = null;
        this.mandatoryButton = this.getWidgetFactory().createButton((Composite)composite, "Mandatory", 32);
        data = new FormData();
        data.left = new FormAttachment((Control)this.ruleIdText, 5);
        data.top = new FormAttachment((Control)this.ruleIdText, 0, 0x1000000);
        this.mandatoryButton.setLayoutData((Object)data);
        this.mandatoryButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.mandatoryModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.mandatoryModified = true;
                PropertySection.this.modifyFields();
            }
        });
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.mandatoryButton, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
    }

    @Override
    public void refresh() {
        super.refresh();
        Stereotype stereotype = this.getValidationStereotype();
        if (stereotype != null && this.modelElement.isStereotypeApplied(stereotype)) {
            Object value = this.modelElement.getValue(stereotype, "mandatory");
            this.mandatoryButton.setSelection(Boolean.TRUE.equals(value));
        } else {
            this.mandatoryButton.setSelection(false);
        }
        if (this.isReadOnly()) {
            this.mandatoryButton.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.mandatoryButton.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(stereotype != null && this.modelElement.isStereotypeApplied(stereotype));
        }
    }
}

