/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Volume;

final class ImmutableVolume
implements Volume {
    @Nullable
    private final String name;
    @Nullable
    private final String driver;
    @Nullable
    private final Map<String, String> driverOpts;
    @Nullable
    private final Map<String, String> options;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final String mountpoint;
    @Nullable
    private final String scope;
    @Nullable
    private final Map<String, String> status;

    private ImmutableVolume(@Nullable String name, @Nullable String driver, @Nullable Map<String, String> driverOpts, @Nullable Map<String, String> options, @Nullable Map<String, String> labels, @Nullable String mountpoint, @Nullable String scope, @Nullable Map<String, String> status) {
        this.name = name;
        this.driver = driver;
        this.driverOpts = driverOpts;
        this.options = options;
        this.labels = labels;
        this.mountpoint = mountpoint;
        this.scope = scope;
        this.status = status;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Driver")
    @Nullable
    public String driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="DriverOpts")
    @Nullable
    public Map<String, String> driverOpts() {
        return this.driverOpts;
    }

    @Override
    @JsonProperty(value="Options")
    @Nullable
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Mountpoint")
    @Nullable
    public String mountpoint() {
        return this.mountpoint;
    }

    @Override
    @JsonProperty(value="Scope")
    @Nullable
    public String scope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="Status")
    @Nullable
    public Map<String, String> status() {
        return this.status;
    }

    public final ImmutableVolume withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableVolume(value, this.driver, this.driverOpts, this.options, this.labels, this.mountpoint, this.scope, this.status);
    }

    public final ImmutableVolume withDriver(@Nullable String value) {
        if (Objects.equals(this.driver, value)) {
            return this;
        }
        return new ImmutableVolume(this.name, value, this.driverOpts, this.options, this.labels, this.mountpoint, this.scope, this.status);
    }

    public final ImmutableVolume withDriverOpts(@Nullable Map<String, ? extends String> entries) {
        if (this.driverOpts == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableVolume.createUnmodifiableMap(true, false, entries);
        return new ImmutableVolume(this.name, this.driver, newValue, this.options, this.labels, this.mountpoint, this.scope, this.status);
    }

    public final ImmutableVolume withOptions(@Nullable Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableVolume.createUnmodifiableMap(true, false, entries);
        return new ImmutableVolume(this.name, this.driver, this.driverOpts, newValue, this.labels, this.mountpoint, this.scope, this.status);
    }

    public final ImmutableVolume withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableVolume.createUnmodifiableMap(true, false, entries);
        return new ImmutableVolume(this.name, this.driver, this.driverOpts, this.options, newValue, this.mountpoint, this.scope, this.status);
    }

    public final ImmutableVolume withMountpoint(@Nullable String value) {
        if (Objects.equals(this.mountpoint, value)) {
            return this;
        }
        return new ImmutableVolume(this.name, this.driver, this.driverOpts, this.options, this.labels, value, this.scope, this.status);
    }

    public final ImmutableVolume withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableVolume(this.name, this.driver, this.driverOpts, this.options, this.labels, this.mountpoint, value, this.status);
    }

    public final ImmutableVolume withStatus(@Nullable Map<String, ? extends String> entries) {
        if (this.status == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableVolume.createUnmodifiableMap(true, false, entries);
        return new ImmutableVolume(this.name, this.driver, this.driverOpts, this.options, this.labels, this.mountpoint, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVolume && this.equalTo(0, (ImmutableVolume)another);
    }

    private boolean equalTo(int synthetic, ImmutableVolume another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.driver, another.driver) && Objects.equals(this.driverOpts, another.driverOpts) && Objects.equals(this.options, another.options) && Objects.equals(this.labels, another.labels) && Objects.equals(this.mountpoint, another.mountpoint) && Objects.equals(this.scope, another.scope) && Objects.equals(this.status, another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.driver);
        h += (h << 5) + Objects.hashCode(this.driverOpts);
        h += (h << 5) + Objects.hashCode(this.options);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.mountpoint);
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + Objects.hashCode(this.status);
        return h;
    }

    public String toString() {
        return "Volume{name=" + this.name + ", driver=" + this.driver + ", driverOpts=" + String.valueOf(this.driverOpts) + ", options=" + String.valueOf(this.options) + ", labels=" + String.valueOf(this.labels) + ", mountpoint=" + this.mountpoint + ", scope=" + this.scope + ", status=" + String.valueOf(this.status) + "}";
    }

    public static ImmutableVolume copyOf(Volume instance) {
        if (instance instanceof ImmutableVolume) {
            return (ImmutableVolume)instance;
        }
        return ImmutableVolume.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements Volume.Builder {
        private String name;
        private String driver;
        private Map<String, String> driverOpts = null;
        private Map<String, String> options = null;
        private Map<String, String> labels = null;
        private String mountpoint;
        private String scope;
        private Map<String, String> status = null;

        private Builder() {
        }

        public final Builder from(Volume instance) {
            Map<String, String> statusValue;
            String scopeValue;
            String mountpointValue;
            Map<String, String> labelsValue;
            Map<String, String> optionsValue;
            Map<String, String> driverOptsValue;
            String driverValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((driverValue = instance.driver()) != null) {
                this.driver(driverValue);
            }
            if ((driverOptsValue = instance.driverOpts()) != null) {
                this.putAllDriverOpts(driverOptsValue);
            }
            if ((optionsValue = instance.options()) != null) {
                this.putAllOptions(optionsValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            if ((mountpointValue = instance.mountpoint()) != null) {
                this.mountpoint(mountpointValue);
            }
            if ((scopeValue = instance.scope()) != null) {
                this.scope(scopeValue);
            }
            if ((statusValue = instance.status()) != null) {
                this.putAllStatus(statusValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonProperty(value="Driver")
        public final Builder driver(@Nullable String driver) {
            this.driver = driver;
            return this;
        }

        public final Builder addDriverOpt(String key, String value) {
            if (this.driverOpts == null) {
                this.driverOpts = new LinkedHashMap<String, String>();
            }
            this.driverOpts.put(Objects.requireNonNull(key, "driverOpts key"), Objects.requireNonNull(value, value == null ? "driverOpts value for key: " + key : null));
            return this;
        }

        public final Builder addDriverOpt(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.driverOpts == null) {
                this.driverOpts = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.driverOpts.put(Objects.requireNonNull(k, "driverOpts key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "driverOpts value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="DriverOpts")
        public final Builder driverOpts(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.driverOpts = null;
                return this;
            }
            this.driverOpts = new LinkedHashMap<String, String>();
            return this.putAllDriverOpts(entries);
        }

        public final Builder putAllDriverOpts(Map<String, ? extends String> entries) {
            if (this.driverOpts == null) {
                this.driverOpts = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.driverOpts.put(Objects.requireNonNull(k, "driverOpts key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "driverOpts value for key: " + k : null));
            }
            return this;
        }

        public final Builder addOption(String key, String value) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
            return this;
        }

        public final Builder addOption(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Options")
        public final Builder options(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.options = null;
                return this;
            }
            this.options = new LinkedHashMap<String, String>();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
            }
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Mountpoint")
        public final Builder mountpoint(@Nullable String mountpoint) {
            this.mountpoint = mountpoint;
            return this;
        }

        @Override
        @JsonProperty(value="Scope")
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        public final Builder addStatu(String key, String value) {
            if (this.status == null) {
                this.status = new LinkedHashMap<String, String>();
            }
            this.status.put(Objects.requireNonNull(key, "status key"), Objects.requireNonNull(value, value == null ? "status value for key: " + key : null));
            return this;
        }

        public final Builder addStatu(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.status == null) {
                this.status = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.status.put(Objects.requireNonNull(k, "status key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "status value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Status")
        public final Builder status(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.status = null;
                return this;
            }
            this.status = new LinkedHashMap<String, String>();
            return this.putAllStatus(entries);
        }

        public final Builder putAllStatus(Map<String, ? extends String> entries) {
            if (this.status == null) {
                this.status = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.status.put(Objects.requireNonNull(k, "status key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "status value for key: " + k : null));
            }
            return this;
        }

        @Override
        public ImmutableVolume build() {
            return new ImmutableVolume(this.name, this.driver, this.driverOpts == null ? null : ImmutableVolume.createUnmodifiableMap(false, false, this.driverOpts), this.options == null ? null : ImmutableVolume.createUnmodifiableMap(false, false, this.options), this.labels == null ? null : ImmutableVolume.createUnmodifiableMap(false, false, this.labels), this.mountpoint, this.scope, this.status == null ? null : ImmutableVolume.createUnmodifiableMap(false, false, this.status));
        }
    }
}

