/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.Messages;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.SimpleTopic;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DevHelpTopic
implements ITopic {
    private static XPath xpath = XPathFactory.newInstance().newXPath();
    private Path path;
    private String bookName;
    private String label;
    private String link;
    private final List<ITopic> subTopics = new ArrayList<ITopic>();

    public DevHelpTopic(Path path) {
        this.path = path;
        this.bookName = path.getParent().getFileName().toString();
        this.init();
    }

    private void init() {
        try {
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setValidating(false);
            docfactory.setFeature("http://xml.org/sax/features/namespaces", false);
            docfactory.setFeature("http://xml.org/sax/features/validation", false);
            docfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            docfactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            Document docroot = docbuilder.parse(this.path.toFile());
            String title = this.xpathEval("/book/@title", docroot);
            if (title != null && !title.isBlank()) {
                this.label = title;
            }
            this.link = this.xpathEval("/book/@link", docroot);
            NodeList nodes = this.xpathEvalNodes("/book/chapters/sub", docroot);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                this.subTopics.add(new SimpleTopic(this.bookName, node));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Platform.getLog((Bundle)FrameworkUtil.getBundle(this.getClass())).error(MessageFormat.format(Messages.DevHelpTopic_ParseXMLError, this.path), (Throwable)e);
        }
    }

    private String xpathEval(String path, Document docroot) {
        String result = "";
        try {
            result = xpath.evaluate(path, docroot);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private NodeList xpathEvalNodes(String path, Document docroot) {
        NodeList result = null;
        try {
            result = (NodeList)xpath.evaluate(path, docroot, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getSubtopics();
    }

    public String getHref() {
        return "/org.eclipse.linuxtools.cdt.libhover.devhelp/" + this.bookName + "/" + this.link;
    }

    public String getLabel() {
        return Objects.requireNonNullElse(this.label, this.bookName);
    }

    public ITopic[] getSubtopics() {
        return this.subTopics.toArray(new ITopic[this.subTopics.size()]);
    }
}

