/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.keyple.seproxy.event.ObservablePlugin;
import org.eclipse.keyple.seproxy.event.PluginEvent;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.plugin.AbstractObservablePlugin;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadedObservablePlugin
extends AbstractObservablePlugin
implements ObservablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(AbstractThreadedObservablePlugin.class);
    private static final long SETTING_THREAD_TIMEOUT_DEFAULT = 1000L;
    private EventThread thread;
    protected long threadWaitTimeout = 1000L;
    private SortedSet<String> nativeReadersNames = new ConcurrentSkipListSet<String>();

    protected abstract SortedSet<String> fetchNativeReadersNames() throws KeypleReaderException;

    public AbstractThreadedObservablePlugin(String name) {
        super(name);
    }

    @Override
    protected void startObservation() {
        this.thread = new EventThread(this.getName());
        this.thread.start();
    }

    @Override
    protected void stopObservation() {
        if (this.thread != null) {
            this.thread.end();
        }
    }

    protected void finalize() throws Throwable {
        this.thread.end();
        this.thread = null;
        logger.trace("[{}] Observable Plugin thread ended.", (Object)this.getName());
        super.finalize();
    }

    private class EventThread
    extends Thread {
        private final String pluginName;
        private boolean running = true;

        private EventThread(String pluginName) {
            this.pluginName = pluginName;
        }

        void end() {
            this.running = false;
            this.interrupt();
        }

        @Override
        public void run() {
            ConcurrentSkipListSet<String> changedReaderNames = new ConcurrentSkipListSet<String>();
            try {
                while (this.running) {
                    SortedSet<String> actualNativeReadersNames = AbstractThreadedObservablePlugin.this.fetchNativeReadersNames();
                    if (!AbstractThreadedObservablePlugin.this.nativeReadersNames.equals(actualNativeReadersNames)) {
                        changedReaderNames.clear();
                        for (AbstractObservableReader reader : AbstractThreadedObservablePlugin.this.readers) {
                            if (actualNativeReadersNames.contains(reader.getName())) continue;
                            changedReaderNames.add(reader.getName());
                        }
                        if (changedReaderNames.size() > 0) {
                            AbstractThreadedObservablePlugin.this.notifyObservers(new PluginEvent(this.pluginName, changedReaderNames, PluginEvent.EventType.READER_DISCONNECTED));
                            for (AbstractObservableReader reader : AbstractThreadedObservablePlugin.this.readers) {
                                if (actualNativeReadersNames.contains(reader.getName())) continue;
                                AbstractThreadedObservablePlugin.this.readers.remove(reader);
                                logger.trace("[{}][{}] Plugin thread => Remove unplugged reader from readers list.", (Object)this.pluginName, (Object)reader.getName());
                                AbstractThreadedObservablePlugin.this.nativeReadersNames.remove(reader.getName());
                            }
                            changedReaderNames.clear();
                        }
                        for (String readerName : actualNativeReadersNames) {
                            if (AbstractThreadedObservablePlugin.this.nativeReadersNames.contains(readerName)) continue;
                            AbstractObservableReader reader = AbstractThreadedObservablePlugin.this.fetchNativeReader(readerName);
                            AbstractThreadedObservablePlugin.this.readers.add(reader);
                            changedReaderNames.add(readerName);
                            logger.trace("[{}][{}] Plugin thread => Add plugged reader to readers list.", (Object)this.pluginName, (Object)reader.getName());
                            AbstractThreadedObservablePlugin.this.nativeReadersNames.add(readerName);
                        }
                        if (changedReaderNames.size() > 0) {
                            AbstractThreadedObservablePlugin.this.notifyObservers(new PluginEvent(this.pluginName, changedReaderNames, PluginEvent.EventType.READER_CONNECTED));
                        }
                    }
                    Thread.sleep(AbstractThreadedObservablePlugin.this.threadWaitTimeout);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                logger.warn("[{}] An exception occurred while monitoring plugin: {}, cause {}", new Object[]{this.pluginName, e.getMessage(), e.getCause()});
            }
            catch (KeypleReaderException e) {
                e.printStackTrace();
                logger.warn("[{}] An exception occurred while monitoring plugin: {}, cause {}", new Object[]{this.pluginName, e.getMessage(), e.getCause()});
            }
        }
    }
}

