/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.keyple.seproxy.exception.NoStackTraceThrowable;
import org.eclipse.keyple.seproxy.plugin.AbstractSelectionLocalReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadedLocalReader
extends AbstractSelectionLocalReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractThreadedLocalReader.class);
    private EventThread thread;
    private static final AtomicInteger threadCount = new AtomicInteger();
    protected long threadWaitTimeout;

    protected AbstractThreadedLocalReader(String pluginName, String readerName) {
        super(pluginName, readerName);
    }

    @Override
    protected void startObservation() {
        this.thread = new EventThread(this.getPluginName(), this.getName());
        this.thread.start();
    }

    @Override
    protected void stopObservation() {
        this.thread.end();
    }

    protected final void setThreadWaitTimeout(long timeout) {
        this.threadWaitTimeout = timeout;
    }

    protected abstract boolean waitForCardPresent(long var1) throws NoStackTraceThrowable;

    protected abstract boolean waitForCardAbsent(long var1) throws NoStackTraceThrowable;

    protected void finalize() throws Throwable {
        this.thread.end();
        this.thread = null;
        logger.trace("[{}] Observable Reader thread ended.", (Object)this.getName());
        super.finalize();
    }

    private class EventThread
    extends Thread {
        private final String pluginName;
        private final String readerName;
        private volatile boolean running;

        EventThread(String pluginName, String readerName) {
            super("observable-reader-events-" + threadCount.addAndGet(1));
            this.running = true;
            this.setDaemon(true);
            this.pluginName = pluginName;
            this.readerName = readerName;
        }

        void end() {
            this.running = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                if (AbstractThreadedLocalReader.this.isSePresent()) {
                    AbstractThreadedLocalReader.this.cardInserted();
                }
                while (this.running) {
                    if (AbstractThreadedLocalReader.this.isSePresent()) {
                        if (!AbstractThreadedLocalReader.this.waitForCardAbsent(AbstractThreadedLocalReader.this.threadWaitTimeout)) continue;
                        AbstractThreadedLocalReader.this.cardRemoved();
                        continue;
                    }
                    if (!AbstractThreadedLocalReader.this.waitForCardPresent(AbstractThreadedLocalReader.this.threadWaitTimeout)) continue;
                    AbstractThreadedLocalReader.this.cardInserted();
                }
            }
            catch (NoStackTraceThrowable e) {
                logger.trace("[{}] Exception occurred in monitoring thread: {}", (Object)this.readerName, (Object)e.getMessage());
            }
        }
    }
}

