/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import org.eclipse.keyple.seproxy.SeReader;
import org.eclipse.keyple.seproxy.event.DefaultSelectionRequest;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.seproxy.exception.KeypleChannelStateException;
import org.eclipse.keyple.seproxy.exception.KeypleIOReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.message.SeRequest;
import org.eclipse.keyple.seproxy.message.SeRequestSet;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.seproxy.message.SeResponseSet;
import org.eclipse.keyple.seproxy.plugin.AbstractLoggedObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservableReader
extends AbstractLoggedObservable<ReaderEvent>
implements ObservableReader,
ProxyReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObservableReader.class);
    private long before;
    protected final String pluginName;
    protected DefaultSelectionRequest defaultSelectionRequest;
    protected ObservableReader.NotificationMode notificationMode;

    protected AbstractObservableReader(String pluginName, String readerName) {
        super(readerName);
        this.pluginName = pluginName;
        this.before = System.nanoTime();
    }

    protected final String getPluginName() {
        return this.pluginName;
    }

    @Override
    public final int compareTo(SeReader seReader) {
        return this.getName().compareTo(seReader.getName());
    }

    @Override
    public final SeResponseSet transmitSet(SeRequestSet requestSet) throws KeypleReaderException {
        SeResponseSet responseSet;
        double elapsedMs;
        long timeStamp;
        if (requestSet == null) {
            throw new IllegalArgumentException("seRequestSet must not be null");
        }
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.debug("[{}] transmit => SEREQUESTSET = {}, elapsed {} ms.", new Object[]{this.getName(), requestSet.toString(), elapsedMs});
        }
        try {
            responseSet = this.processSeRequestSet(requestSet);
        }
        catch (KeypleChannelStateException ex) {
            long timeStamp2 = System.nanoTime();
            double elapsedMs2 = (double)((timeStamp2 - this.before) / 100000L) / 10.0;
            this.before = timeStamp2;
            logger.debug("[{}] transmit => SEREQUESTSET channel failure. elapsed {}", (Object)elapsedMs2);
            throw ex;
        }
        catch (KeypleIOReaderException ex) {
            long timeStamp3 = System.nanoTime();
            double elapsedMs3 = (double)((timeStamp3 - this.before) / 100000L) / 10.0;
            this.before = timeStamp3;
            logger.debug("[{}] transmit => SEREQUESTSET IO failure. elapsed {}", (Object)elapsedMs3);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.debug("[{}] transmit => SERESPONSESET = {}, elapsed {} ms.", new Object[]{this.getName(), responseSet.toString(), elapsedMs});
        }
        return responseSet;
    }

    protected abstract SeResponseSet processSeRequestSet(SeRequestSet var1) throws KeypleReaderException;

    @Override
    public final SeResponse transmit(SeRequest seRequest) throws KeypleReaderException {
        double elapsedMs;
        long timeStamp;
        if (seRequest == null) {
            throw new IllegalArgumentException("seRequest must not be null");
        }
        SeResponse seResponse = null;
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.debug("[{}] transmit => SEREQUEST = {}, elapsed {} ms.", new Object[]{this.getName(), seRequest.toString(), elapsedMs});
        }
        try {
            seResponse = this.processSeRequest(seRequest);
        }
        catch (KeypleChannelStateException ex) {
            long timeStamp2 = System.nanoTime();
            double elapsedMs2 = (double)((timeStamp2 - this.before) / 100000L) / 10.0;
            this.before = timeStamp2;
            logger.debug("[{}] transmit => SEREQUEST channel failure. elapsed {}", (Object)this.getName(), (Object)elapsedMs2);
            throw ex;
        }
        catch (KeypleIOReaderException ex) {
            long timeStamp3 = System.nanoTime();
            double elapsedMs3 = (double)((timeStamp3 - this.before) / 100000L) / 10.0;
            this.before = timeStamp3;
            logger.debug("[{}] transmit => SEREQUEST IO failure. elapsed {}", (Object)this.getName(), (Object)elapsedMs3);
            throw ex;
        }
        if (logger.isDebugEnabled()) {
            timeStamp = System.nanoTime();
            elapsedMs = (double)((timeStamp - this.before) / 100000L) / 10.0;
            this.before = timeStamp;
            logger.debug("[{}] transmit => SERESPONSE = {}, elapsed {} ms.", new Object[]{this.getName(), seResponse.toString(), elapsedMs});
        }
        return seResponse;
    }

    protected abstract SeResponse processSeRequest(SeRequest var1) throws KeypleReaderException;

    protected abstract void startObservation();

    protected abstract void stopObservation();

    @Override
    public final void addObserver(ObservableReader.ReaderObserver observer) {
        if (super.countObservers() == 0) {
            logger.debug("Start the reader monitoring.");
            this.startObservation();
        }
        super.addObserver(observer);
    }

    @Override
    public final void removeObserver(ObservableReader.ReaderObserver observer) {
        super.removeObserver(observer);
        if (super.countObservers() == 0) {
            logger.debug("Stop the reader monitoring.");
            this.stopObservation();
        }
    }
}

