/**
 * File:    TransformatioExportnWizardPage.java
 * Created: 26.11.2008
 *
 *
/*******************************************************************************
 * Copyright (c) 2008  Open Wide (www.openwide.fr)
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Mickael Istria, Open Wide, Lyon, France
 *      - Creation and implementation
 *******************************************************************************/

package org.eclipse.jwt.transformations.exportTransformations.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.jwt.transformations.exportTransformations.ExportJWTTransformationRequestDesc;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TransformationExportWizardPage extends WizardPage {

	private static final String PAGE_NAME = TransformationsMessages.exportWizard_pageName;
	private ExportJWTTransformationRequestDesc exportTransfoDesc;
	private String originalInFilePath;
	private boolean useCurrentModel;

	public TransformationExportWizardPage() {
		super(PAGE_NAME);
		this.setTitle(TransformationsMessages.exportWizard_pageTitle);
        this.setDescription(TransformationsMessages.exportWizard_pageDescription);
	}

	public void createControl(Composite parent) {
		if (this.getControl() == null) {
			exportTransfoDesc = new ExportJWTTransformationRequestDesc(parent, new CompletedPageListener());
			if (this.originalInFilePath != null) {
				exportTransfoDesc.setInFilePath(this.originalInFilePath);
			} else if (this.useCurrentModel) {
				exportTransfoDesc.useCurrentModel();
			}
			setControl(exportTransfoDesc.createControl());
			setPageComplete(exportTransfoDesc.hasAllRequiredInfo());
		}
	}


	public boolean finish() {
		return exportTransfoDesc.apply();
	}
	
	private class CompletedPageListener implements Listener {
		public void handleEvent(Event event) {
			TransformationExportWizardPage.this.setPageComplete(exportTransfoDesc.hasAllRequiredInfo());
		}
	}

	public void setToExportItem(String inFilePath) {
		this.originalInFilePath = inFilePath;
	}

	public void useCurrentModel() {
		this.useCurrentModel = true;
	}
}

