/*******************************************************************************
 * Copyright (c) 2005-2012
 * University of Augsburg, Germany <www.ds-lab.org>
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Markus Bauer, Programming distributed Systems Lab, University of Augsburg 
 *    	- initial API and implementation
 *    Wolf Fischer, Programming distributed Systems Lab, University of Augsburg
 *      - view support
 *    Christian Saad, Programming distributed Systems Lab, University of Augsburg
 *      - maintenance and extension 
 *******************************************************************************/
package org.eclipse.jwt.meta.model.processes.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jwt.meta.model.processes.util.ProcessesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ProcessesItemProviderAdapterFactory extends ProcessesAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */

	public static final String copyright = "Copyright (c) 2005-2012  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();


	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessesItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.Scope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScopeItemProvider scopeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.Scope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createScopeAdapter()
	{
		if (scopeItemProvider == null)
		{
			scopeItemProvider = new ScopeItemProvider(this);
		}

		return scopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.Activity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityItemProvider activityItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.Activity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityAdapter()
	{
		if (activityItemProvider == null)
		{
			activityItemProvider = new ActivityItemProvider(this);
		}

		return activityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.StructuredActivityNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructuredActivityNodeItemProvider structuredActivityNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.StructuredActivityNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructuredActivityNodeAdapter()
	{
		if (structuredActivityNodeItemProvider == null)
		{
			structuredActivityNodeItemProvider = new StructuredActivityNodeItemProvider(
					this);
		}

		return structuredActivityNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.ActivityNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityNodeItemProvider activityNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.ActivityNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityNodeAdapter()
	{
		if (activityNodeItemProvider == null)
		{
			activityNodeItemProvider = new ActivityNodeItemProvider(this);
		}

		return activityNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.ActivityEdge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityEdgeItemProvider activityEdgeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.ActivityEdge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityEdgeAdapter()
	{
		if (activityEdgeItemProvider == null)
		{
			activityEdgeItemProvider = new ActivityEdgeItemProvider(this);
		}

		return activityEdgeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.GuardSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuardSpecificationItemProvider guardSpecificationItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.GuardSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGuardSpecificationAdapter()
	{
		if (guardSpecificationItemProvider == null)
		{
			guardSpecificationItemProvider = new GuardSpecificationItemProvider(this);
		}

		return guardSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.ExecutableNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutableNodeItemProvider executableNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.ExecutableNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutableNodeAdapter()
	{
		if (executableNodeItemProvider == null)
		{
			executableNodeItemProvider = new ExecutableNodeItemProvider(this);
		}

		return executableNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.Action} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActionItemProvider actionItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.Action}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActionAdapter()
	{
		if (actionItemProvider == null)
		{
			actionItemProvider = new ActionItemProvider(this);
		}

		return actionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.ControlNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlNodeItemProvider controlNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.ControlNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createControlNodeAdapter()
	{
		if (controlNodeItemProvider == null)
		{
			controlNodeItemProvider = new ControlNodeItemProvider(this);
		}

		return controlNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.InitialNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InitialNodeItemProvider initialNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.InitialNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInitialNodeAdapter()
	{
		if (initialNodeItemProvider == null)
		{
			initialNodeItemProvider = new InitialNodeItemProvider(this);
		}

		return initialNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.ForkNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForkNodeItemProvider forkNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.ForkNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForkNodeAdapter()
	{
		if (forkNodeItemProvider == null)
		{
			forkNodeItemProvider = new ForkNodeItemProvider(this);
		}

		return forkNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.JoinNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JoinNodeItemProvider joinNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.JoinNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJoinNodeAdapter()
	{
		if (joinNodeItemProvider == null)
		{
			joinNodeItemProvider = new JoinNodeItemProvider(this);
		}

		return joinNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.MergeNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MergeNodeItemProvider mergeNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.MergeNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMergeNodeAdapter()
	{
		if (mergeNodeItemProvider == null)
		{
			mergeNodeItemProvider = new MergeNodeItemProvider(this);
		}

		return mergeNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.DecisionNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecisionNodeItemProvider decisionNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.DecisionNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecisionNodeAdapter()
	{
		if (decisionNodeItemProvider == null)
		{
			decisionNodeItemProvider = new DecisionNodeItemProvider(this);
		}

		return decisionNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.FinalNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FinalNodeItemProvider finalNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.FinalNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFinalNodeAdapter()
	{
		if (finalNodeItemProvider == null)
		{
			finalNodeItemProvider = new FinalNodeItemProvider(this);
		}

		return finalNodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.Guard} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuardItemProvider guardItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.Guard}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGuardAdapter()
	{
		if (guardItemProvider == null)
		{
			guardItemProvider = new GuardItemProvider(this);
		}

		return guardItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.jwt.meta.model.processes.ActivityLinkNode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActivityLinkNodeItemProvider activityLinkNodeItemProvider;


	/**
	 * This creates an adapter for a {@link org.eclipse.jwt.meta.model.processes.ActivityLinkNode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActivityLinkNodeAdapter()
	{
		if (activityLinkNodeItemProvider == null)
		{
			activityLinkNodeItemProvider = new ActivityLinkNodeItemProvider(this);
		}

		return activityLinkNodeItemProvider;
	}


	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}


	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}


	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class<?>) type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}


	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}


	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}


	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}


	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose()
	{
		if (scopeItemProvider != null)
			scopeItemProvider.dispose();
		if (activityItemProvider != null)
			activityItemProvider.dispose();
		if (structuredActivityNodeItemProvider != null)
			structuredActivityNodeItemProvider.dispose();
		if (activityNodeItemProvider != null)
			activityNodeItemProvider.dispose();
		if (activityEdgeItemProvider != null)
			activityEdgeItemProvider.dispose();
		if (guardSpecificationItemProvider != null)
			guardSpecificationItemProvider.dispose();
		if (executableNodeItemProvider != null)
			executableNodeItemProvider.dispose();
		if (actionItemProvider != null)
			actionItemProvider.dispose();
		if (controlNodeItemProvider != null)
			controlNodeItemProvider.dispose();
		if (initialNodeItemProvider != null)
			initialNodeItemProvider.dispose();
		if (forkNodeItemProvider != null)
			forkNodeItemProvider.dispose();
		if (joinNodeItemProvider != null)
			joinNodeItemProvider.dispose();
		if (mergeNodeItemProvider != null)
			mergeNodeItemProvider.dispose();
		if (decisionNodeItemProvider != null)
			decisionNodeItemProvider.dispose();
		if (finalNodeItemProvider != null)
			finalNodeItemProvider.dispose();
		if (guardItemProvider != null)
			guardItemProvider.dispose();
		if (activityLinkNodeItemProvider != null)
			activityLinkNodeItemProvider.dispose();
	}

}
