/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.handlers.AttachEiqEditorRegistrationHandler;
import org.eclipse.incquery.tooling.ui.queryexplorer.handlers.PatternUnregistrationHandler;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.BasePartListener;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class AttachFileEditorPartListener
extends BasePartListener {
    private AttachEiqEditorRegistrationHandler attachHandler;

    public AttachFileEditorPartListener(AttachEiqEditorRegistrationHandler h) {
        this.attachHandler = h;
    }

    @Override
    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IFile file;
            IEditorPart closedEditor = (IEditorPart)part;
            IEditorInput editorInput = closedEditor.getEditorInput();
            IWorkbenchWindow activeWorkbenchWindow = part.getSite().getWorkbenchWindow();
            if (editorInput instanceof FileEditorInput && (file = ((FileEditorInput)editorInput).getFile()) != null && file.getFileExtension().matches("eiq") && this.attachHandler.thereIsAnAttachedEditorForFile(file) && QueryExplorerPatternRegistry.getInstance().getFiles().contains(file)) {
                boolean answer = false;
                if (answer) {
                    PatternUnregistrationHandler puh = new PatternUnregistrationHandler();
                    for (IQuerySpecification<?> qs : QueryExplorerPatternRegistry.getInstance().getRegisteredPatternsForFile(file)) {
                        puh.unregisterPattern(QueryExplorer.getInstance(activeWorkbenchWindow), qs.getFullyQualifiedName());
                    }
                }
                this.attachHandler.removeAttachmentRegistrationForFile(file);
            }
        }
    }
}

