package org.eclipse.incquery.viewers.runtime.model.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.viewers.runtime.model.patterns.ChildrenMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.ChildrenMatcher;

/**
 * A pattern-specific query specification that can instantiate ChildrenMatcher in a type-safe way.
 * 
 * @see ChildrenMatcher
 * @see ChildrenMatch
 * 
 */
@SuppressWarnings("all")
public final class ChildrenQuerySpecification extends BaseGeneratedEMFQuerySpecification<ChildrenMatcher> {
  private ChildrenQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ChildrenQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ChildrenMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ChildrenMatcher.on(engine);
  }
  
  @Override
  public ChildrenMatch newEmptyMatch() {
    return ChildrenMatch.newEmptyMatch();
  }
  
  @Override
  public ChildrenMatch newMatch(final Object... parameters) {
    return ChildrenMatch.newMatch((org.eclipse.incquery.viewers.runtime.model.Item) parameters[0], (org.eclipse.incquery.viewers.runtime.model.Item) parameters[1]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link ChildrenQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link ChildrenQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static ChildrenQuerySpecification INSTANCE = new ChildrenQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ChildrenQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.viewers.runtime.model.patterns.children";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("parent","child");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("parent", "org.eclipse.incquery.viewers.runtime.model.Item"),new PParameter("child", "org.eclipse.incquery.viewers.runtime.model.Item"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_parent = body.getOrCreateVariableByName("parent");
      		PVariable var_child = body.getOrCreateVariableByName("child");
      		PVariable var_c = body.getOrCreateVariableByName("c");
      		new TypeConstraint(body, new FlatTuple(var_parent), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Item")));
      		new TypeConstraint(body, new FlatTuple(var_child), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Item")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_parent, "parent"),
      		   new ExportedParameter(body, var_child, "child")
      		));
      		// 	Containment.source(c, parent)
      		new TypeConstraint(body, new FlatTuple(var_c), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Containment")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_c, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Edge", "source")));
      		new Equality(body, var__virtual_0_, var_parent);
      		// 	Containment.target(c, child)
      		new TypeConstraint(body, new FlatTuple(var_c), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Containment")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_c, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Edge", "target")));
      		new Equality(body, var__virtual_1_, var_child);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
