/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.apiimpl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQueryGroup;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngineLifecycleListener;
import org.eclipse.incquery.runtime.api.IncQueryEngineManager;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.api.scope.IBaseIndex;
import org.eclipse.incquery.runtime.api.scope.IEngineContext;
import org.eclipse.incquery.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QueryBackendRegistry;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.internal.engine.LifecycleProvider;
import org.eclipse.incquery.runtime.internal.engine.ModelUpdateProvider;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.incquery.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.incquery.runtime.matchers.backend.IUpdateable;
import org.eclipse.incquery.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class IncQueryEngineImpl
extends AdvancedIncQueryEngine
implements IQueryBackendHintProvider {
    private final IncQueryEngineManager manager;
    private final IncQueryScope scope;
    private IEngineContext engineContext;
    private final Map<PQuery, QueryEvaluationHint> hints = Maps.newHashMap();
    private final Map<IQuerySpecification<? extends IncQueryMatcher<?>>, IncQueryMatcher<?>> matchers = Maps.newHashMap();
    private volatile Map<Class<? extends IQueryBackend>, IQueryBackend> queryBackends = null;
    private final LifecycleProvider lifecycleProvider;
    private final ModelUpdateProvider modelUpdateProvider;
    private Logger logger;
    private boolean disposed = false;
    private boolean tainted = false;
    private IIndexingErrorListener taintListener = new SelfTaintListener(this);

    public IncQueryEngineImpl(IncQueryEngineManager manager, IncQueryScope scope) throws IncQueryException {
        this.manager = manager;
        this.scope = scope;
        this.lifecycleProvider = new LifecycleProvider(this, this.getLogger());
        this.modelUpdateProvider = new ModelUpdateProvider(this, this.getLogger());
        this.engineContext = scope.createEngineContext(this, this.taintListener, this.getLogger());
    }

    @Override
    public Notifier getEMFRoot() {
        return ((EMFScope)this.scope).getScopeRoot();
    }

    @Override
    public Set<? extends IncQueryMatcher<? extends IPatternMatch>> getCurrentMatchers() {
        return ImmutableSet.copyOf(this.matchers.values());
    }

    @Override
    public <Matcher extends IncQueryMatcher<? extends IPatternMatch>> Matcher getMatcher(IQuerySpecification<Matcher> querySpecification) throws IncQueryException {
        return querySpecification.getMatcher(this);
    }

    @Override
    public <Matcher extends IncQueryMatcher<? extends IPatternMatch>> Matcher getMatcher(IQuerySpecification<Matcher> querySpecification, QueryEvaluationHint optionalEvaluationHints) throws IncQueryException {
        this.overrideKnownHints(querySpecification.getInternalQueryRepresentation(), optionalEvaluationHints);
        return this.getMatcher(querySpecification);
    }

    @Override
    public <Matcher extends IncQueryMatcher<? extends IPatternMatch>> Matcher getExistingMatcher(IQuerySpecification<Matcher> querySpecification) {
        return (Matcher)this.matchers.get(querySpecification);
    }

    @Override
    public IncQueryMatcher<? extends IPatternMatch> getMatcher(String patternFQN) throws IncQueryException {
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpecification = QuerySpecificationRegistry.getQuerySpecification(patternFQN);
        if (querySpecification != null) {
            return this.getMatcher(querySpecification);
        }
        throw new IncQueryException(String.format("No matcher could be constructed for the pattern with FQN %s; if the generated matcher class is not available, please access for the first time using getMatcher(IQuerySpecification)", patternFQN), "No matcher could be constructed for given pattern FQN.");
    }

    @Override
    public IBaseIndex getBaseIndex() throws IncQueryException {
        return this.engineContext.getBaseIndex();
    }

    public final Logger getLogger() {
        if (this.logger == null) {
            int hash = System.identityHashCode(this);
            this.logger = Logger.getLogger((String)(String.valueOf(IncQueryLoggingUtil.getLogger(IncQueryEngine.class).getName()) + "." + hash));
            if (this.logger == null) {
                throw new AssertionError((Object)("Configuration error: unable to create IncQuery runtime logger for engine " + hash));
            }
        }
        return this.logger;
    }

    public void reportMatcherInitialized(IQuerySpecification<?> querySpecification, IncQueryMatcher<?> matcher) {
        if (this.matchers.containsKey(querySpecification)) {
            this.logger.debug((Object)("Query " + querySpecification.getFullyQualifiedName() + " already initialized in IncQueryEngine!"));
        } else {
            this.matchers.put(querySpecification, matcher);
            this.lifecycleProvider.matcherInstantiated(matcher);
        }
    }

    @Override
    public IQueryBackend getQueryBackend(Class<? extends IQueryBackend> backendClass) throws IncQueryException {
        IQueryBackend iQueryBackend;
        if (this.queryBackends == null) {
            this.initBackends();
        }
        if ((iQueryBackend = this.queryBackends.get(backendClass)) == null) {
            throw new IncQueryException("Query backend class not registered: " + backendClass.getName(), "Unknown query backend.");
        }
        return iQueryBackend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBackends() throws IncQueryException {
        IncQueryEngineImpl incQueryEngineImpl = this;
        synchronized (incQueryEngineImpl) {
            if (this.queryBackends == null) {
                boolean initialized = false;
                try {
                    this.engineContext.initializeBackends(new IEngineContext.IQueryBackendInitializer(){

                        @Override
                        public void initializeWith(IPatternMatcherRuntimeContext context) {
                            IncQueryEngineImpl.this.queryBackends = Maps.newHashMap();
                            for (Map.Entry<Class<? extends IQueryBackend>, IQueryBackendFactory> factoryEntry : QueryBackendRegistry.getInstance().getAllKnownFactories()) {
                                IQueryBackend backend = factoryEntry.getValue().create(context, (IQueryBackendHintProvider)IncQueryEngineImpl.this);
                                IncQueryEngineImpl.this.queryBackends.put(factoryEntry.getKey(), backend);
                            }
                        }
                    });
                    initialized = true;
                }
                finally {
                    if (!initialized) {
                        this.queryBackends = null;
                    }
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this.manager != null) {
            throw new UnsupportedOperationException(String.format("Cannot dispose() managed IncQuery engine. Attempted for scope %s.", this.scope));
        }
        this.wipe();
        this.disposed = true;
        this.lifecycleProvider.engineDisposed();
        try {
            this.engineContext.dispose();
        }
        catch (IllegalStateException illegalStateException) {
            this.getLogger().warn((Object)"The base index could not be disposed along with the InQuery engine, as there are still active listeners on it.");
        }
    }

    @Override
    public void wipe() {
        if (this.manager != null) {
            throw new UnsupportedOperationException(String.format("Cannot wipe() managed IncQuery engine. Attempted for scope %s.", this.scope));
        }
        if (this.queryBackends != null) {
            for (IQueryBackend backend : this.queryBackends.values()) {
                backend.dispose();
            }
            this.queryBackends = null;
        }
        this.hints.clear();
        this.matchers.clear();
        this.lifecycleProvider.engineWiped();
    }

    @Override
    public boolean isTainted() {
        return this.tainted;
    }

    @Override
    public boolean isManaged() {
        return this.manager != null;
    }

    private <Match extends IPatternMatch> IQueryResultProvider getUnderlyingResultProvider(BaseMatcher<Match> matcher) {
        return matcher.backend;
    }

    @Override
    public <Match extends IPatternMatch> void addMatchUpdateListener(final IncQueryMatcher<Match> matcher, final IMatchUpdateListener<? super Match> listener, boolean fireNow) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        Preconditions.checkArgument((matcher.getEngine() == this ? 1 : 0) != 0, (Object)"Cannot register listener for matcher of different engine!");
        Preconditions.checkArgument((!this.disposed ? 1 : 0) != 0, (Object)"Cannot register listener on matcher of disposed engine!");
        final BaseMatcher bm = (BaseMatcher)matcher;
        IUpdateable updateDispatcher = new IUpdateable(){

            public void update(Tuple updateElement, boolean isInsertion) {
                IPatternMatch match = null;
                try {
                    match = (IPatternMatch)bm.newMatch(updateElement.getElements());
                    if (isInsertion) {
                        listener.notifyAppearance(match);
                    } else {
                        listener.notifyDisappearance(match);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    IncQueryEngineImpl.this.logger.warn((Object)String.format("The incremental pattern matcher encountered an error during %s a callback on %s of match %s of pattern %s. Error message: %s. (Developer note: %s in %s callback)", match == null ? "preparing" : "invoking", isInsertion ? "insertion" : "removal", match == null ? updateElement.toString() : match.prettyPrint(), matcher.getPatternName(), e.getMessage(), e.getClass().getSimpleName(), listener), e);
                }
            }
        };
        IQueryResultProvider resultProvider = this.getUnderlyingResultProvider(bm);
        resultProvider.addUpdateListener(updateDispatcher, listener, fireNow);
    }

    @Override
    public <Match extends IPatternMatch> void removeMatchUpdateListener(IncQueryMatcher<Match> matcher, IMatchUpdateListener<? super Match> listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        Preconditions.checkArgument((matcher.getEngine() == this ? 1 : 0) != 0, (Object)"Cannot remove listener from matcher of different engine!");
        Preconditions.checkArgument((!this.disposed ? 1 : 0) != 0, (Object)"Cannot remove listener from matcher of disposed engine!");
        BaseMatcher bm = (BaseMatcher)matcher;
        try {
            IQueryResultProvider resultProvider = this.getUnderlyingResultProvider(bm);
            resultProvider.removeUpdateListener(listener);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while removing listener " + listener + " from the matcher of " + matcher.getPatternName()), (Throwable)e);
        }
    }

    @Override
    public void addModelUpdateListener(IncQueryModelUpdateListener listener) {
        this.modelUpdateProvider.addListener(listener);
    }

    @Override
    public void removeModelUpdateListener(IncQueryModelUpdateListener listener) {
        this.modelUpdateProvider.removeListener(listener);
    }

    @Override
    public void addLifecycleListener(IncQueryEngineLifecycleListener listener) {
        this.lifecycleProvider.addListener(listener);
    }

    @Override
    public void removeLifecycleListener(IncQueryEngineLifecycleListener listener) {
        this.lifecycleProvider.removeListener(listener);
    }

    public IQueryResultProvider getResultProvider(IQuerySpecification<?> query) throws QueryProcessingException, IncQueryException {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Cannot evaluate query on disposed engine!");
        return this.getResultProviderInternal(query);
    }

    private IQueryResultProvider getResultProviderInternal(IQuerySpecification<?> query) throws QueryProcessingException, IncQueryException {
        IQueryBackend backend = this.getQueryBackend(query);
        return backend.getResultProvider(query.getInternalQueryRepresentation());
    }

    private IQueryBackend getQueryBackend(IQuerySpecification<?> query) throws IncQueryException {
        return this.getQueryBackend(this.getCurrentHint(query.getInternalQueryRepresentation()).getQueryBackendClass());
    }

    public Map<String, Object> getHints(PQuery query) {
        return this.getCurrentHint(query).getBackendHints();
    }

    private QueryEvaluationHint getCurrentHint(PQuery query) {
        QueryEvaluationHint hint = this.hints.get(query);
        if (hint == null) {
            hint = new QueryEvaluationHint(QueryBackendRegistry.getInstance().getDefaultBackendClass(), new HashMap());
            this.hints.put(query, hint);
            QueryEvaluationHint providedHint = query.getEvaluationHints();
            if (providedHint != null) {
                hint = this.overrideKnownHints(query, providedHint);
            }
        }
        return hint;
    }

    private QueryEvaluationHint overrideKnownHints(PQuery query, QueryEvaluationHint overridingHint) {
        QueryEvaluationHint currentHint = this.getCurrentHint(query);
        if (overridingHint == null) {
            return currentHint;
        }
        Class queryBackendClass = currentHint.getQueryBackendClass();
        if (overridingHint.getQueryBackendClass() != null) {
            queryBackendClass = overridingHint.getQueryBackendClass();
        }
        HashMap backendHints = new HashMap(currentHint.getBackendHints());
        if (overridingHint.getBackendHints() != null) {
            backendHints.putAll(overridingHint.getBackendHints());
        }
        QueryEvaluationHint consolidatendHint = new QueryEvaluationHint(queryBackendClass, backendHints);
        this.hints.put(query, consolidatendHint);
        return consolidatendHint;
    }

    @Override
    public void prepareGroup(IQueryGroup queryGroup, final QueryEvaluationHint optionalEvaluationHints) throws IncQueryException {
        try {
            Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Cannot evaluate query on disposed engine!");
            final HashSet specifications = new HashSet(queryGroup.getSpecifications());
            Collection patterns = Collections2.transform(specifications, (Function)new Function<IQuerySpecification, PQuery>(){

                public PQuery apply(IQuerySpecification input) {
                    return input.getInternalQueryRepresentation();
                }
            });
            Collection uninitializedPatterns = Collections2.transform((Collection)Collections2.filter((Collection)patterns, (Predicate)PQueries.queryStatusPredicate((PQuery.PQueryStatus)PQuery.PQueryStatus.UNINITIALIZED)), (Function)PQueries.queryNameFunction());
            Preconditions.checkState((boolean)uninitializedPatterns.isEmpty(), (String)"Uninitialized query(s) found: %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)uninitializedPatterns)});
            Collection erroneousPatterns = Collections2.transform((Collection)Collections2.filter((Collection)patterns, (Predicate)PQueries.queryStatusPredicate((PQuery.PQueryStatus)PQuery.PQueryStatus.ERROR)), (Function)PQueries.queryNameFunction());
            Preconditions.checkState((boolean)erroneousPatterns.isEmpty(), (String)"Erroneous query(s) found: %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)erroneousPatterns)});
            try {
                this.engineContext.getBaseIndex().coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (IQuerySpecification query : specifications) {
                            IncQueryEngineImpl.this.overrideKnownHints(query.getInternalQueryRepresentation(), optionalEvaluationHints);
                        }
                        for (IQuerySpecification query : specifications) {
                            IncQueryEngineImpl.this.getResultProviderInternal(query);
                        }
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof QueryProcessingException) {
                    throw (QueryProcessingException)cause;
                }
                if (cause instanceof IncQueryException) {
                    throw (IncQueryException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                assert (false);
            }
        }
        catch (QueryProcessingException e) {
            throw new IncQueryException(e);
        }
    }

    @Override
    public IncQueryScope getScope() {
        return this.scope;
    }

    private static class SelfTaintListener
    implements IIndexingErrorListener {
        WeakReference<IncQueryEngineImpl> iqEngRef;
        private boolean noTaintDetectedYet = true;

        public SelfTaintListener(IncQueryEngineImpl iqEngine) {
            this.iqEngRef = new WeakReference<IncQueryEngineImpl>(iqEngine);
        }

        public void engineBecameTainted(String description, Throwable t) {
            IncQueryEngineImpl iqEngine = (IncQueryEngineImpl)this.iqEngRef.get();
            if (iqEngine != null) {
                iqEngine.tainted = true;
                iqEngine.lifecycleProvider.engineBecameTainted(description, t);
            }
        }

        protected void notifyTainted(String description, Throwable t) {
            if (this.noTaintDetectedYet) {
                this.noTaintDetectedYet = false;
                this.engineBecameTainted(description, t);
            }
        }

        @Override
        public void error(String description, Throwable t) {
        }

        @Override
        public void fatal(String description, Throwable t) {
            this.notifyTainted(description, t);
        }
    }
}

