/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.index.StandardIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.tuple.MaskedTupleMemory;

public abstract class IndexerWithMemory
extends StandardIndexer
implements Receiver {
    protected MaskedTupleMemory memory;

    public MaskedTupleMemory getMemory() {
        return this.memory;
    }

    public IndexerWithMemory(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer, mask);
        this.memory = new MaskedTupleMemory(mask);
        reteContainer.registerClearable(this.memory);
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        Tuple signature = this.mask.transform(updateElement);
        boolean change = direction == Direction.INSERT ? this.memory.add(updateElement, signature) : this.memory.remove(updateElement, signature);
        this.update(direction, updateElement, signature, change);
    }

    protected abstract void update(Direction var1, Tuple var2, Tuple var3, boolean var4);

    @Override
    public void appendParent(Supplier supplier) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Illegal RETE edge: " + this + " already has a parent (" + this.parent + ") and cannot connect to additional parent (" + supplier + "). ");
        }
        this.parent = supplier;
    }

    @Override
    public void removeParent(Supplier supplier) {
        if (this.parent != supplier) {
            throw new IllegalArgumentException("Illegal RETE edge removal: the parent of " + this + " is not " + supplier);
        }
        this.parent = null;
    }

    @Override
    public Collection<Supplier> getParents() {
        return Collections.singleton(this.parent);
    }
}

