/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.ExternalInputNode;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.recipes.InputRecipe;
import org.eclipse.incquery.runtime.rete.remote.Address;

public final class InputConnector {
    Network network;
    protected Table<IInputKey, Tuple, Address<ExternalInputNode>> externalInputRoots = HashBasedTable.create((int)100, (int)1);

    public InputConnector(Network network) {
        this.network = network;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void connectInput(InputRecipe recipe, Node freshNode) {
        ExternalInputNode inputNode = (ExternalInputNode)freshNode;
        IInputKey inputKey = (IInputKey)recipe.getInputKey();
        Tuple seed = this.nopSeed(inputKey);
        Address<ExternalInputNode> freshAddress = Address.of(inputNode);
        this.externalInputRoots.put((Object)inputKey, (Object)seed, freshAddress);
        inputNode.connectThroughContext(this.network.getEngine(), inputKey, seed);
    }

    public Object wrapElement(Object element) {
        return element;
    }

    public Object unwrapElement(Object wrapper) {
        return wrapper;
    }

    public Tuple wrapTuple(Tuple unwrapped) {
        return unwrapped;
    }

    public Tuple unwrapTuple(Tuple wrappers) {
        return wrappers;
    }

    public Collection<Address<ExternalInputNode>> getAllExternalInputNodes() {
        return this.externalInputRoots.values();
    }

    public Collection<Address<ExternalInputNode>> getAllExternalInputNodesForKey(IInputKey inputKey) {
        return this.externalInputRoots.row((Object)inputKey).values();
    }

    public Address<ExternalInputNode> getExternalInputNodeForKeyUnseeded(IInputKey inputKey) {
        return (Address)this.externalInputRoots.get((Object)inputKey, null);
    }

    public Address<ExternalInputNode> getExternalInputNode(IInputKey inputKey, Tuple seed) {
        if (seed == null) {
            seed = this.nopSeed(inputKey);
        }
        return (Address)this.externalInputRoots.get((Object)inputKey, (Object)seed);
    }

    Tuple nopSeed(IInputKey inputKey) {
        return new FlatTuple(new Object[inputKey.getArity()]);
    }
}

