/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.scheduler;

import org.eclipse.incquery.runtime.evm.api.Executor;
import org.eclipse.incquery.runtime.evm.api.Scheduler;

public class TimedScheduler
extends Scheduler {
    private long interval;
    private volatile boolean interrupted = false;

    protected TimedScheduler(Executor executor, long interval) {
        super(executor);
        this.interval = interval;
        new FiringThread().start();
    }

    @Override
    public void dispose() {
        this.interrupted = true;
    }

    private class FiringThread
    extends Thread {
        public FiringThread() {
            this.setName("TimedFiringStrategy [interval: " + TimedScheduler.this.interval + "]");
        }

        @Override
        public void run() {
            while (!TimedScheduler.this.interrupted) {
                TimedScheduler.this.schedule();
                try {
                    Thread.sleep(TimedScheduler.this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class TimedSchedulerFactory
    implements Scheduler.ISchedulerFactory {
        private long interval;

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public long getInterval() {
            return this.interval;
        }

        @Override
        public Scheduler prepareScheduler(Executor engine) {
            return new TimedScheduler(engine, this.interval);
        }

        public TimedSchedulerFactory(long interval) {
            this.interval = interval;
        }
    }
}

