/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Preconditions;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.event.AbstractRuleInstanceBuilder;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventHandler;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSource;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSourceSpecification;

public class IncQueryRuleInstanceBuilder<Match extends IPatternMatch>
extends AbstractRuleInstanceBuilder<Match> {
    private IncQueryEventRealm realm;
    private IncQueryEventSourceSpecification<Match> sourceSpecification;

    @Override
    public void prepareRuleInstance(RuleInstance<Match> ruleInstance, EventFilter<? super Match> filter) {
        Preconditions.checkArgument((ruleInstance != null ? 1 : 0) != 0, (Object)"Cannot prepare null rule instance!");
        IncQueryEventSource source = (IncQueryEventSource)Preconditions.checkNotNull(this.realm.createSource(this.sourceSpecification), (Object)"Could not create source in realm!");
        IncQueryEventHandler handler = (IncQueryEventHandler)Preconditions.checkNotNull(new IncQueryEventHandler<Match>(source, filter, ruleInstance), (Object)"Could not create handler in source!");
        handler.prepareEventHandler();
    }

    protected IncQueryRuleInstanceBuilder(IncQueryEventRealm realm, IncQueryEventSourceSpecification<Match> sourceSpecification) {
        Preconditions.checkArgument((realm != null ? 1 : 0) != 0, (Object)"Cannot create builder with null realm!");
        Preconditions.checkArgument((sourceSpecification != null ? 1 : 0) != 0, (Object)"Cannot create builder with null realm!");
        this.realm = realm;
        this.sourceSpecification = sourceSpecification;
    }
}

