package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementQualifiedNameMatch;
import org.eclipse.uml2.uml.NamedElement;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.namedElementQualifiedName pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NamedElementQualifiedNameProcessor implements IMatchProcessor<NamedElementQualifiedNameMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pNamedElement the value of pattern parameter namedElement in the currently processed match
   * @param pQualifiedName the value of pattern parameter qualifiedName in the currently processed match
   * 
   */
  public abstract void process(final NamedElement pNamedElement, final Object pQualifiedName);
  
  @Override
  public void process(final NamedElementQualifiedNameMatch match) {
    process(match.getNamedElement(), match.getQualifiedName());
  }
}
