/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.comprehension;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.incquery.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.comprehension.WellbehavingDerivedFeatureRegistry;

public class EMFModelComprehension {
    private BaseIndexOptions options;

    public EMFModelComprehension(BaseIndexOptions options) {
        this.options = options.copy();
    }

    public boolean untraversableDirectly(EStructuralFeature feature) {
        if (feature instanceof EReference && ((EReference)feature).isContainer()) {
            return true;
        }
        boolean suspect = this.onlySamplingFeature(feature);
        if (suspect) {
            suspect = this.options.isTraverseOnlyWellBehavingDerivedFeatures();
        }
        return suspect;
    }

    public boolean onlySamplingFeature(EStructuralFeature feature) {
        boolean suspect;
        boolean bl = suspect = feature.isDerived() || feature.isVolatile();
        if (suspect) {
            suspect = !WellbehavingDerivedFeatureRegistry.isWellbehavingFeature(feature);
        }
        return suspect;
    }

    public boolean representable(EStructuralFeature feature) {
        EReference reference;
        if (!this.untraversableDirectly(feature)) {
            return true;
        }
        if (feature instanceof EReference && (reference = (EReference)feature).isContainer() && this.representable((EStructuralFeature)reference.getEOpposite())) {
            return true;
        }
        boolean isMixed = "mixed".equals(EcoreUtil.getAnnotation((EModelElement)feature.getEContainingClass(), (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"kind"));
        if (isMixed) {
            return true;
        }
        String groupAnnotation = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"group");
        if (groupAnnotation != null && groupAnnotation.length() > 1 && '#' == groupAnnotation.charAt(0)) {
            String groupFeatureName = groupAnnotation.substring(1);
            EStructuralFeature groupFeature = feature.getEContainingClass().getEStructuralFeature(groupFeatureName);
            return this.representable(groupFeature);
        }
        return false;
    }

    public void traverseModel(EMFVisitor visitor, Notifier source) {
        if (source == null) {
            return;
        }
        if (source instanceof EObject) {
            EObject sourceObject = (EObject)source;
            if (sourceObject.eIsProxy()) {
                throw new IllegalArgumentException("Proxy EObject cannot act as model roots for EMF-IncQuery: " + source);
            }
            this.traverseObject(visitor, sourceObject);
        } else if (source instanceof Resource) {
            this.traverseResource(visitor, (Resource)source);
        } else if (source instanceof ResourceSet) {
            this.traverseResourceSet(visitor, (ResourceSet)source);
        }
    }

    public void traverseResourceSet(EMFVisitor visitor, ResourceSet source) {
        if (source == null) {
            return;
        }
        ArrayList resources = new ArrayList(source.getResources());
        for (Resource resource : resources) {
            this.traverseResourceIfUnfiltered(visitor, resource);
        }
    }

    public void traverseResourceIfUnfiltered(EMFVisitor visitor, Resource resource) {
        IBaseIndexResourceFilter resourceFilter = this.options.getResourceFilterConfiguration();
        if (resourceFilter != null && resourceFilter.isResourceFiltered(resource)) {
            return;
        }
        IBaseIndexObjectFilter objectFilter = this.options.getObjectFilterConfiguration();
        if (objectFilter != null && objectFilter.isFiltered((Notifier)resource)) {
            return;
        }
        this.traverseResource(visitor, resource);
    }

    public void traverseResource(EMFVisitor visitor, Resource source) {
        if (source == null) {
            return;
        }
        if (visitor.pruneSubtrees(source)) {
            return;
        }
        EList contents = source.getContents();
        for (EObject eObject : contents) {
            this.traverseObjectIfUnfiltered(visitor, eObject);
        }
    }

    public void traverseObjectIfUnfiltered(EMFVisitor visitor, EObject targetObject) {
        IBaseIndexObjectFilter objectFilter = this.options.getObjectFilterConfiguration();
        if (objectFilter != null && objectFilter.isFiltered((Notifier)targetObject)) {
            return;
        }
        this.traverseObject(visitor, targetObject);
    }

    public void traverseObject(EMFVisitor visitor, EObject source) {
        if (source == null) {
            return;
        }
        if (visitor.preOrder()) {
            visitor.visitElement(source);
        }
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            boolean visitorPrunes;
            if (this.untraversableDirectly(feature) || (visitorPrunes = visitor.pruneFeature(feature)) && !this.unprunableFeature(visitor, source, feature)) continue;
            this.traverseFeatureTargets(visitor, source, feature, visitorPrunes);
        }
        if (!visitor.preOrder()) {
            visitor.visitElement(source);
        }
    }

    protected void traverseFeatureTargets(EMFVisitor visitor, EObject source, EStructuralFeature feature, boolean visitorPrunes) {
        boolean attemptResolve;
        boolean bl = attemptResolve = feature instanceof EAttribute || visitor.attemptProxyResolutions(source, (EReference)feature);
        if (feature.isMany()) {
            EList targets = (EList)source.eGet(feature);
            int position = 0;
            Iterator iterator = attemptResolve ? targets.iterator() : ((InternalEList)targets).basicIterator();
            while (iterator.hasNext()) {
                Object target = iterator.next();
                this.traverseFeatureInternal(visitor, source, feature, target, visitorPrunes, position++);
            }
        } else {
            Object target = source.eGet(feature, attemptResolve);
            if (target != null) {
                this.traverseFeatureInternal(visitor, source, feature, target, visitorPrunes, null);
            }
        }
    }

    private boolean unprunableFeature(EMFVisitor visitor, EObject source, EStructuralFeature feature) {
        return feature instanceof EAttribute && EcorePackage.eINSTANCE.getEFeatureMapEntry().equals(((EAttribute)feature).getEAttributeType()) || feature instanceof EReference && ((EReference)feature).isContainment() && (!visitor.pruneSubtrees(source) || ((EReference)feature).getEOpposite() != null);
    }

    public void traverseFeature(EMFVisitor visitor, EObject source, EStructuralFeature feature, Object target, Integer position) {
        if (target == null) {
            return;
        }
        if (this.untraversableDirectly(feature)) {
            return;
        }
        this.traverseFeatureInternalSimple(visitor, source, feature, target, position);
    }

    private void traverseFeatureInternalSimple(EMFVisitor visitor, EObject source, EStructuralFeature feature, Object target, Integer position) {
        boolean visitorPrunes = visitor.pruneFeature(feature);
        if (visitorPrunes && !this.unprunableFeature(visitor, source, feature)) {
            return;
        }
        this.traverseFeatureInternal(visitor, source, feature, target, visitorPrunes, position);
    }

    private void traverseFeatureInternal(EMFVisitor visitor, EObject source, EStructuralFeature feature, Object target, boolean visitorPrunes, Integer position) {
        if (feature instanceof EAttribute) {
            if (!visitorPrunes) {
                visitor.visitAttribute(source, (EAttribute)feature, target);
            }
            if (target instanceof FeatureMap.Entry) {
                FeatureMap.Entry entry = (FeatureMap.Entry)target;
                EStructuralFeature emulated = entry.getEStructuralFeature();
                Object emulatedTarget = entry.getValue();
                this.emulateUntraversableFeature(visitor, source, emulated, emulatedTarget);
            }
        } else if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            EObject targetObject = (EObject)target;
            if (reference.isContainment()) {
                if (!visitor.avoidTransientContainmentLink(source, reference, targetObject)) {
                    EReference opposite;
                    if (!visitorPrunes) {
                        visitor.visitInternalContainment(source, reference, targetObject);
                    }
                    if (!visitor.pruneSubtrees(source)) {
                        this.traverseObjectIfUnfiltered(visitor, targetObject);
                    }
                    if ((opposite = reference.getEOpposite()) != null) {
                        this.emulateUntraversableFeature(visitor, targetObject, (EStructuralFeature)opposite, source);
                    }
                }
            } else if (!visitorPrunes) {
                visitor.visitNonContainmentReference(source, reference, targetObject);
            }
            if (targetObject.eIsProxy()) {
                if (!reference.isResolveProxies()) {
                    throw new IllegalStateException(String.format("EReference '%s' of EClass %s is set as proxy-non-resolving (i.e. it should never point to a proxy, and never lead cross-resource), yet EMF-IncQuery Base encountered a proxy object %s referenced from %s.", reference.getName(), reference.getEContainingClass().getInstanceTypeName(), targetObject, source));
                }
                visitor.visitProxyReference(source, reference, targetObject, position);
            }
        }
    }

    private void emulateUntraversableFeature(EMFVisitor visitor, EObject source, EStructuralFeature emulated, Object target) {
        if (this.untraversableDirectly(emulated)) {
            this.traverseFeatureInternalSimple(visitor, source, emulated, target, null);
        }
    }

    public void tryResolveReference(EObject source, EReference reference) {
        Object result = source.eGet((EStructuralFeature)reference, true);
        if (reference.isMany()) {
            Iterator iterator = ((Iterable)result).iterator();
            while (iterator.hasNext()) {
                EObject cfr_ignored_0 = (EObject)iterator.next();
            }
        }
    }

    public boolean isLoading(Resource resource) {
        return !resource.isLoaded() || ((Resource.Internal)resource).isLoading();
    }
}

