/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStickyAssignor
extends AbstractPartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(AbstractStickyAssignor.class);
    public static final int DEFAULT_GENERATION = -1;
    public int maxGeneration = -1;
    private PartitionMovements partitionMovements;
    protected Map<TopicPartition, String> partitionsTransferringOwnership = new HashMap<TopicPartition, String>();

    protected abstract MemberData memberData(ConsumerPartitionAssignor.Subscription var1);

    @Override
    public Map<String, List<TopicPartition>> assignPartitions(Map<String, List<PartitionInfo>> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        AbstractAssignmentBuilder assignmentBuilder;
        HashMap<String, List<TopicPartition>> consumerToOwnedPartitions = new HashMap<String, List<TopicPartition>>();
        HashSet<TopicPartition> partitionsWithMultiplePreviousOwners = new HashSet<TopicPartition>();
        ArrayList<PartitionInfo> allPartitions = new ArrayList<PartitionInfo>();
        partitionsPerTopic.values().forEach(allPartitions::addAll);
        RackInfo rackInfo = new RackInfo(allPartitions, subscriptions);
        if (this.allSubscriptionsEqual(partitionsPerTopic.keySet(), subscriptions, consumerToOwnedPartitions, partitionsWithMultiplePreviousOwners)) {
            log.debug("Detected that all consumers were subscribed to same set of topics, invoking the optimized assignment algorithm");
            this.partitionsTransferringOwnership = new HashMap<TopicPartition, String>();
            assignmentBuilder = new ConstrainedAssignmentBuilder(partitionsPerTopic, rackInfo, consumerToOwnedPartitions, partitionsWithMultiplePreviousOwners);
        } else {
            log.debug("Detected that not all consumers were subscribed to same set of topics, falling back to the general case assignment algorithm");
            this.partitionsTransferringOwnership = null;
            assignmentBuilder = new GeneralAssignmentBuilder(partitionsPerTopic, rackInfo, consumerToOwnedPartitions, subscriptions);
        }
        return ((AbstractAssignmentBuilder)assignmentBuilder).build();
    }

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        return this.assignPartitions(AbstractStickyAssignor.partitionInfosWithoutRacks(partitionsPerTopic), subscriptions);
    }

    private boolean allSubscriptionsEqual(Set<String> allTopics, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> consumerToOwnedPartitions, Set<TopicPartition> partitionsWithMultiplePreviousOwners) {
        boolean isAllSubscriptionsEqual = true;
        HashSet<String> subscribedTopics = new HashSet<String>();
        HashMap<TopicPartition, String> allPreviousPartitionsToOwner = new HashMap<TopicPartition, String>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> subscriptionEntry : subscriptions.entrySet()) {
            String consumer = subscriptionEntry.getKey();
            ConsumerPartitionAssignor.Subscription subscription = subscriptionEntry.getValue();
            if (subscribedTopics.isEmpty()) {
                subscribedTopics.addAll(subscription.topics());
            } else if (isAllSubscriptionsEqual && (subscription.topics().size() != subscribedTopics.size() || !subscribedTopics.containsAll(subscription.topics()))) {
                isAllSubscriptionsEqual = false;
            }
            MemberData memberData = this.memberData(subscription);
            int memberGeneration = memberData.generation.orElse(-1);
            this.maxGeneration = Math.max(this.maxGeneration, memberGeneration);
            ArrayList<TopicPartition> ownedPartitions = new ArrayList<TopicPartition>();
            consumerToOwnedPartitions.put(consumer, ownedPartitions);
            for (TopicPartition tp : memberData.partitions) {
                if (!allTopics.contains(tp.topic())) continue;
                String otherConsumer = (String)allPreviousPartitionsToOwner.get(tp);
                if (otherConsumer == null) {
                    ownedPartitions.add(tp);
                    allPreviousPartitionsToOwner.put(tp, consumer);
                    continue;
                }
                int otherMemberGeneration = subscriptions.get(otherConsumer).generationId().orElse(-1);
                if (memberGeneration == otherMemberGeneration) {
                    log.error("Found multiple consumers {} and {} claiming the same TopicPartition {} in the same generation {}, this will be invalidated and removed from their previous assignment.", consumer, otherConsumer, tp, memberGeneration);
                    partitionsWithMultiplePreviousOwners.add(tp);
                    consumerToOwnedPartitions.get(otherConsumer).remove(tp);
                    allPreviousPartitionsToOwner.put(tp, consumer);
                    continue;
                }
                if (memberGeneration > otherMemberGeneration) {
                    ownedPartitions.add(tp);
                    consumerToOwnedPartitions.get(otherConsumer).remove(tp);
                    allPreviousPartitionsToOwner.put(tp, consumer);
                    log.warn("Consumer {} in generation {} and consumer {} in generation {} claiming the same TopicPartition {} in different generations. The topic partition will be assigned to the member with the higher generation {}.", consumer, memberGeneration, otherConsumer, otherMemberGeneration, tp, memberGeneration);
                    continue;
                }
                log.warn("Consumer {} in generation {} and consumer {} in generation {} claiming the same TopicPartition {} in different generations. The topic partition will be assigned to the member with the higher generation {}.", consumer, memberGeneration, otherConsumer, otherMemberGeneration, tp, otherMemberGeneration);
            }
        }
        return isAllSubscriptionsEqual;
    }

    public boolean isSticky() {
        return this.partitionMovements.isSticky();
    }

    private class GeneralAssignmentBuilder
    extends AbstractAssignmentBuilder {
        private final Map<String, ConsumerPartitionAssignor.Subscription> subscriptions;
        private final Map<String, List<String>> topic2AllPotentialConsumers;
        private final Map<String, List<String>> consumer2AllPotentialTopics;
        private final Map<TopicPartition, String> currentPartitionConsumer;
        private final List<TopicPartition> sortedAllPartitions;
        private final TreeSet<String> sortedCurrentSubscriptions;
        private boolean revocationRequired;

        GeneralAssignmentBuilder(Map<String, List<PartitionInfo>> partitionsPerTopic, RackInfo rackInfo, Map<String, List<TopicPartition>> currentAssignment, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
            super(partitionsPerTopic, rackInfo, currentAssignment);
            this.subscriptions = subscriptions;
            this.topic2AllPotentialConsumers = new HashMap<String, List<String>>(partitionsPerTopic.keySet().size());
            this.consumer2AllPotentialTopics = new HashMap<String, List<String>>(subscriptions.keySet().size());
            partitionsPerTopic.keySet().forEach(topicName -> {
                List cfr_ignored_0 = this.topic2AllPotentialConsumers.put((String)topicName, new ArrayList());
            });
            subscriptions.forEach((consumerId, subscription) -> {
                ArrayList subscribedTopics = new ArrayList(subscription.topics().size());
                this.consumer2AllPotentialTopics.put((String)consumerId, subscribedTopics);
                subscription.topics().stream().filter(topic -> partitionsPerTopic.get(topic) != null).forEach(topic -> {
                    subscribedTopics.add(topic);
                    this.topic2AllPotentialConsumers.get(topic).add((String)consumerId);
                });
                if (!currentAssignment.containsKey(consumerId)) {
                    currentAssignment.put((String)consumerId, new ArrayList());
                }
            });
            this.currentPartitionConsumer = new HashMap<TopicPartition, String>();
            for (Map.Entry<String, List<TopicPartition>> entry : currentAssignment.entrySet()) {
                for (TopicPartition topicPartition : entry.getValue()) {
                    this.currentPartitionConsumer.put(topicPartition, entry.getKey());
                }
            }
            ArrayList<String> sortedAllTopics = new ArrayList<String>(this.topic2AllPotentialConsumers.keySet());
            Collections.sort(sortedAllTopics, new TopicComparator(this.topic2AllPotentialConsumers));
            this.sortedAllPartitions = this.getAllTopicPartitions(sortedAllTopics);
            this.sortedCurrentSubscriptions = new TreeSet<String>(new SubscriptionComparator(currentAssignment));
        }

        @Override
        Map<String, List<TopicPartition>> build() {
            if (log.isDebugEnabled()) {
                log.debug("performing general assign. partitionsPerTopic: {}, subscriptions: {}, currentAssignment: {}, rackInfo: {}", this.partitionsPerTopic, this.subscriptions, this.currentAssignment, this.rackInfo);
            }
            HashMap<TopicPartition, ConsumerGenerationPair> prevAssignment = new HashMap<TopicPartition, ConsumerGenerationPair>();
            AbstractStickyAssignor.this.partitionMovements = new PartitionMovements();
            this.prepopulateCurrentAssignments(prevAssignment);
            List<TopicPartition> assignedPartitions = this.assignOwnedPartitions();
            List<TopicPartition> unassignedPartitions = this.getUnassignedPartitions(assignedPartitions);
            if (log.isDebugEnabled()) {
                log.debug("unassigned Partitions: {}", (Object)unassignedPartitions);
            }
            this.sortedCurrentSubscriptions.addAll(this.currentAssignment.keySet());
            this.balance(prevAssignment, unassignedPartitions);
            log.info("Final assignment of partitions to consumers: \n{}", (Object)this.currentAssignment);
            return this.currentAssignment;
        }

        private List<TopicPartition> assignOwnedPartitions() {
            ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
            Iterator it = this.currentAssignment.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String consumer = (String)entry.getKey();
                ConsumerPartitionAssignor.Subscription consumerSubscription = this.subscriptions.get(consumer);
                if (consumerSubscription == null) {
                    for (TopicPartition topicPartition : (List)entry.getValue()) {
                        this.currentPartitionConsumer.remove(topicPartition);
                    }
                    it.remove();
                    continue;
                }
                Iterator partitionIter = ((List)entry.getValue()).iterator();
                while (partitionIter.hasNext()) {
                    TopicPartition partition = (TopicPartition)partitionIter.next();
                    if (!this.topic2AllPotentialConsumers.containsKey(partition.topic())) {
                        partitionIter.remove();
                        this.currentPartitionConsumer.remove(partition);
                        continue;
                    }
                    if (!consumerSubscription.topics().contains(partition.topic()) || this.rackInfo.racksMismatch(consumer, partition)) {
                        partitionIter.remove();
                        this.revocationRequired = true;
                        continue;
                    }
                    assignedPartitions.add(partition);
                }
            }
            return assignedPartitions;
        }

        private List<TopicPartition> getUnassignedPartitions(List<TopicPartition> sortedAssignedPartitions) {
            if (sortedAssignedPartitions.isEmpty()) {
                return this.sortedAllPartitions;
            }
            ArrayList<TopicPartition> unassignedPartitions = new ArrayList<TopicPartition>();
            Collections.sort(sortedAssignedPartitions, new Utils.PartitionComparator(this.topic2AllPotentialConsumers));
            boolean shouldAddDirectly = false;
            Iterator<TopicPartition> sortedAssignedPartitionsIter = sortedAssignedPartitions.iterator();
            TopicPartition nextAssignedPartition = sortedAssignedPartitionsIter.next();
            for (TopicPartition topicPartition : this.sortedAllPartitions) {
                if (shouldAddDirectly || !nextAssignedPartition.equals(topicPartition)) {
                    unassignedPartitions.add(topicPartition);
                    continue;
                }
                if (sortedAssignedPartitionsIter.hasNext()) {
                    nextAssignedPartition = sortedAssignedPartitionsIter.next();
                    continue;
                }
                shouldAddDirectly = true;
            }
            return unassignedPartitions;
        }

        private void updatePrevAssignment(Map<TopicPartition, ConsumerGenerationPair> prevAssignment, List<TopicPartition> partitions, String consumer, int generation) {
            for (TopicPartition partition : partitions) {
                if (prevAssignment.containsKey(partition)) {
                    if (generation <= prevAssignment.get((Object)partition).generation) continue;
                    prevAssignment.put(partition, new ConsumerGenerationPair(consumer, generation));
                    continue;
                }
                prevAssignment.put(partition, new ConsumerGenerationPair(consumer, generation));
            }
        }

        private void prepopulateCurrentAssignments(Map<TopicPartition, ConsumerGenerationPair> prevAssignment) {
            for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> subscriptionEntry : this.subscriptions.entrySet()) {
                String consumer = subscriptionEntry.getKey();
                ConsumerPartitionAssignor.Subscription subscription = subscriptionEntry.getValue();
                if (subscription.userData() != null) {
                    subscription.userData().rewind();
                }
                MemberData memberData = AbstractStickyAssignor.this.memberData(subscription);
                if (memberData.generation.isPresent() && memberData.generation.get() < AbstractStickyAssignor.this.maxGeneration) {
                    this.updatePrevAssignment(prevAssignment, memberData.partitions, consumer, memberData.generation.get());
                    continue;
                }
                if (memberData.generation.isPresent() || AbstractStickyAssignor.this.maxGeneration <= -1) continue;
                this.updatePrevAssignment(prevAssignment, memberData.partitions, consumer, -1);
            }
        }

        private boolean isBalanced() {
            int max;
            int min = ((List)this.currentAssignment.get(this.sortedCurrentSubscriptions.first())).size();
            if (min >= (max = ((List)this.currentAssignment.get(this.sortedCurrentSubscriptions.last())).size()) - 1) {
                return true;
            }
            HashMap allPartitions = new HashMap();
            Set assignments = this.currentAssignment.entrySet();
            for (Map.Entry entry : assignments) {
                List topicPartitions = (List)entry.getValue();
                for (TopicPartition topicPartition : topicPartitions) {
                    if (allPartitions.containsKey(topicPartition)) {
                        log.error("{} is assigned to more than one consumer.", (Object)topicPartition);
                    }
                    allPartitions.put(topicPartition, entry.getKey());
                }
            }
            for (String consumer : this.sortedCurrentSubscriptions) {
                List<String> allSubscribedTopics;
                int maxAssignmentSize;
                List consumerPartitions = (List)this.currentAssignment.get(consumer);
                int consumerPartitionCount = consumerPartitions.size();
                if (consumerPartitionCount == (maxAssignmentSize = this.getMaxAssignmentSize(allSubscribedTopics = this.consumer2AllPotentialTopics.get(consumer)))) continue;
                for (String topic : allSubscribedTopics) {
                    int partitionCount = ((List)this.partitionsPerTopic.get(topic)).size();
                    for (int i = 0; i < partitionCount; ++i) {
                        String otherConsumer;
                        int otherConsumerPartitionCount;
                        TopicPartition topicPartition = new TopicPartition(topic, i);
                        if (((List)this.currentAssignment.get(consumer)).contains(topicPartition) || consumerPartitionCount + 1 >= (otherConsumerPartitionCount = ((List)this.currentAssignment.get(otherConsumer = (String)allPartitions.get(topicPartition))).size())) continue;
                        log.debug("{} can be moved from consumer {} to consumer {} for a more balanced assignment.", topicPartition, otherConsumer, consumer);
                        return false;
                    }
                }
            }
            return true;
        }

        private int getMaxAssignmentSize(List<String> allSubscribedTopics) {
            int maxAssignmentSize = allSubscribedTopics.size() == this.partitionsPerTopic.size() ? this.totalPartitionsCount : allSubscribedTopics.stream().map(this.partitionsPerTopic::get).map(List::size).reduce(0, Integer::sum);
            return maxAssignmentSize;
        }

        private int getBalanceScore(Map<String, List<TopicPartition>> assignment) {
            int score = 0;
            HashMap<String, Integer> consumer2AssignmentSize = new HashMap<String, Integer>();
            for (Map.Entry<String, List<TopicPartition>> entry : assignment.entrySet()) {
                consumer2AssignmentSize.put(entry.getKey(), entry.getValue().size());
            }
            Iterator it = consumer2AssignmentSize.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, List<TopicPartition>> entry;
                entry = it.next();
                int consumerAssignmentSize = (Integer)((Object)entry.getValue());
                it.remove();
                for (Map.Entry otherEntry : consumer2AssignmentSize.entrySet()) {
                    score += Math.abs(consumerAssignmentSize - (Integer)otherEntry.getValue());
                }
            }
            return score;
        }

        private boolean maybeAssignPartition(TopicPartition partition, RackInfo rackInfo) {
            for (String consumer : this.sortedCurrentSubscriptions) {
                if (!this.consumer2AllPotentialTopics.get(consumer).contains(partition.topic()) || rackInfo != null && rackInfo.racksMismatch(consumer, partition)) continue;
                this.sortedCurrentSubscriptions.remove(consumer);
                ((List)this.currentAssignment.get(consumer)).add(partition);
                this.currentPartitionConsumer.put(partition, consumer);
                this.sortedCurrentSubscriptions.add(consumer);
                return true;
            }
            return false;
        }

        private void maybeAssign(List<TopicPartition> unassignedPartitions, RackInfo rackInfo, boolean removeAssigned) {
            Iterator<TopicPartition> iter = unassignedPartitions.iterator();
            while (iter.hasNext()) {
                TopicPartition partition = iter.next();
                if (this.topic2AllPotentialConsumers.get(partition.topic()).isEmpty() || !this.maybeAssignPartition(partition, rackInfo) || !removeAssigned) continue;
                iter.remove();
            }
        }

        private boolean canTopicParticipateInReassignment(String topic) {
            return this.topic2AllPotentialConsumers.get(topic).size() >= 2;
        }

        private boolean canConsumerParticipateInReassignment(String consumer) {
            List<String> allSubscribedTopics;
            int maxAssignmentSize;
            List currentPartitions = (List)this.currentAssignment.get(consumer);
            int currentAssignmentSize = currentPartitions.size();
            if (currentAssignmentSize > (maxAssignmentSize = this.getMaxAssignmentSize(allSubscribedTopics = this.consumer2AllPotentialTopics.get(consumer)))) {
                log.error("The consumer {} is assigned more partitions than the maximum possible.", (Object)consumer);
            }
            if (currentAssignmentSize < maxAssignmentSize) {
                return true;
            }
            for (TopicPartition partition : currentPartitions) {
                if (!this.canTopicParticipateInReassignment(partition.topic())) continue;
                return true;
            }
            return false;
        }

        private void balance(Map<TopicPartition, ConsumerGenerationPair> prevAssignment, List<TopicPartition> unassignedPartitions) {
            boolean initializing = ((List)this.currentAssignment.get(this.sortedCurrentSubscriptions.last())).isEmpty();
            List<TopicPartition> partitionsToAssign = unassignedPartitions;
            if (!this.rackInfo.consumerRacks.isEmpty()) {
                partitionsToAssign = new LinkedList<TopicPartition>(unassignedPartitions);
                this.maybeAssign(partitionsToAssign, this.rackInfo, true);
            }
            this.maybeAssign(partitionsToAssign, null, false);
            HashSet<TopicPartition> fixedPartitions = new HashSet<TopicPartition>();
            for (String string : this.topic2AllPotentialConsumers.keySet()) {
                if (this.canTopicParticipateInReassignment(string)) continue;
                for (int i = 0; i < ((List)this.partitionsPerTopic.get(string)).size(); ++i) {
                    fixedPartitions.add(new TopicPartition(string, i));
                }
            }
            this.sortedAllPartitions.removeAll(fixedPartitions);
            unassignedPartitions.removeAll(fixedPartitions);
            HashMap fixedAssignments = new HashMap();
            for (String consumer : this.consumer2AllPotentialTopics.keySet()) {
                if (this.canConsumerParticipateInReassignment(consumer)) continue;
                this.sortedCurrentSubscriptions.remove(consumer);
                fixedAssignments.put(consumer, this.currentAssignment.remove(consumer));
            }
            Map<String, List<TopicPartition>> map = this.deepCopy(this.currentAssignment);
            HashMap<TopicPartition, String> preBalancePartitionConsumers = new HashMap<TopicPartition, String>(this.currentPartitionConsumer);
            if (!this.revocationRequired) {
                this.performReassignments(unassignedPartitions, prevAssignment);
            }
            boolean reassignmentPerformed = this.performReassignments(this.sortedAllPartitions, prevAssignment);
            if (!initializing && reassignmentPerformed && this.getBalanceScore(this.currentAssignment) >= this.getBalanceScore(map)) {
                this.deepCopy(map, this.currentAssignment);
                this.currentPartitionConsumer.clear();
                this.currentPartitionConsumer.putAll(preBalancePartitionConsumers);
            }
            for (Map.Entry entry : fixedAssignments.entrySet()) {
                String consumer = (String)entry.getKey();
                this.currentAssignment.put(consumer, entry.getValue());
                this.sortedCurrentSubscriptions.add(consumer);
            }
            fixedAssignments.clear();
        }

        private boolean performReassignments(List<TopicPartition> reassignablePartitions, Map<TopicPartition, ConsumerGenerationPair> prevAssignment) {
            boolean modified;
            boolean reassignmentPerformed = false;
            do {
                modified = false;
                Iterator<TopicPartition> partitionIterator = reassignablePartitions.iterator();
                block1: while (partitionIterator.hasNext() && !this.isBalanced()) {
                    String consumer;
                    TopicPartition partition = partitionIterator.next();
                    if (this.topic2AllPotentialConsumers.get(partition.topic()).size() <= 1) {
                        log.error("Expected more than one potential consumer for partition '{}'", (Object)partition);
                    }
                    if ((consumer = this.currentPartitionConsumer.get(partition)) == null) {
                        log.error("Expected partition '{}' to be assigned to a consumer", (Object)partition);
                    }
                    if (prevAssignment.containsKey(partition) && ((List)this.currentAssignment.get(consumer)).size() > ((List)this.currentAssignment.get(prevAssignment.get((Object)partition).consumer)).size() + 1) {
                        this.reassignPartition(partition, prevAssignment.get((Object)partition).consumer);
                        reassignmentPerformed = true;
                        modified = true;
                        continue;
                    }
                    String consumerRack = (String)this.rackInfo.consumerRacks.get(consumer);
                    Set partitionRacks = (Set)this.rackInfo.partitionRacks.get(partition);
                    boolean foundRackConsumer = false;
                    if (consumerRack != null && !partitionRacks.isEmpty() && partitionRacks.contains(consumerRack)) {
                        for (String otherConsumer : this.topic2AllPotentialConsumers.get(partition.topic())) {
                            String otherConsumerRack = (String)this.rackInfo.consumerRacks.get(otherConsumer);
                            if (otherConsumerRack == null || !partitionRacks.contains(otherConsumerRack) || ((List)this.currentAssignment.get(consumer)).size() <= ((List)this.currentAssignment.get(otherConsumer)).size() + 1) continue;
                            this.reassignPartition(partition);
                            reassignmentPerformed = true;
                            modified = true;
                            foundRackConsumer = true;
                            break;
                        }
                    }
                    if (foundRackConsumer) continue;
                    for (String otherConsumer : this.topic2AllPotentialConsumers.get(partition.topic())) {
                        if (((List)this.currentAssignment.get(consumer)).size() <= ((List)this.currentAssignment.get(otherConsumer)).size() + 1) continue;
                        this.reassignPartition(partition);
                        reassignmentPerformed = true;
                        modified = true;
                        continue block1;
                    }
                }
            } while (modified);
            return reassignmentPerformed;
        }

        private void reassignPartition(TopicPartition partition) {
            String newConsumer = null;
            for (String anotherConsumer : this.sortedCurrentSubscriptions) {
                if (!this.consumer2AllPotentialTopics.get(anotherConsumer).contains(partition.topic())) continue;
                newConsumer = anotherConsumer;
                break;
            }
            assert (newConsumer != null);
            this.reassignPartition(partition, newConsumer);
        }

        private void reassignPartition(TopicPartition partition, String newConsumer) {
            String consumer = this.currentPartitionConsumer.get(partition);
            TopicPartition partitionToBeMoved = AbstractStickyAssignor.this.partitionMovements.getTheActualPartitionToBeMoved(partition, consumer, newConsumer);
            this.processPartitionMovement(partitionToBeMoved, newConsumer);
        }

        private void processPartitionMovement(TopicPartition partition, String newConsumer) {
            String oldConsumer = this.currentPartitionConsumer.get(partition);
            this.sortedCurrentSubscriptions.remove(oldConsumer);
            this.sortedCurrentSubscriptions.remove(newConsumer);
            AbstractStickyAssignor.this.partitionMovements.movePartition(partition, oldConsumer, newConsumer);
            ((List)this.currentAssignment.get(oldConsumer)).remove(partition);
            ((List)this.currentAssignment.get(newConsumer)).add(partition);
            this.currentPartitionConsumer.put(partition, newConsumer);
            this.sortedCurrentSubscriptions.add(newConsumer);
            this.sortedCurrentSubscriptions.add(oldConsumer);
        }

        private void deepCopy(Map<String, List<TopicPartition>> source, Map<String, List<TopicPartition>> dest) {
            dest.clear();
            for (Map.Entry<String, List<TopicPartition>> entry : source.entrySet()) {
                dest.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }

        private Map<String, List<TopicPartition>> deepCopy(Map<String, List<TopicPartition>> assignment) {
            HashMap<String, List<TopicPartition>> copy = new HashMap<String, List<TopicPartition>>();
            this.deepCopy(assignment, copy);
            return copy;
        }
    }

    private class ConstrainedAssignmentBuilder
    extends AbstractAssignmentBuilder {
        private final Set<TopicPartition> partitionsWithMultiplePreviousOwners;
        private final Set<TopicPartition> allRevokedPartitions;
        private final List<String> unfilledMembersWithUnderMinQuotaPartitions;
        private final LinkedList<String> unfilledMembersWithExactlyMinQuotaPartitions;
        private final int minQuota;
        private final int maxQuota;
        private final int expectedNumMembersWithOverMinQuotaPartitions;
        private int currentNumMembersWithOverMinQuotaPartitions;
        private final Map<String, List<TopicPartition>> assignment;
        private final List<TopicPartition> assignedPartitions;

        ConstrainedAssignmentBuilder(Map<String, List<PartitionInfo>> partitionsPerTopic, RackInfo rackInfo, Map<String, List<TopicPartition>> consumerToOwnedPartitions, Set<TopicPartition> partitionsWithMultiplePreviousOwners) {
            super(partitionsPerTopic, rackInfo, consumerToOwnedPartitions);
            this.partitionsWithMultiplePreviousOwners = partitionsWithMultiplePreviousOwners;
            this.allRevokedPartitions = new HashSet<TopicPartition>();
            this.unfilledMembersWithUnderMinQuotaPartitions = new LinkedList<String>();
            this.unfilledMembersWithExactlyMinQuotaPartitions = new LinkedList();
            int numberOfConsumers = consumerToOwnedPartitions.size();
            this.minQuota = (int)Math.floor((double)this.totalPartitionsCount / (double)numberOfConsumers);
            this.maxQuota = (int)Math.ceil((double)this.totalPartitionsCount / (double)numberOfConsumers);
            this.expectedNumMembersWithOverMinQuotaPartitions = this.totalPartitionsCount % numberOfConsumers;
            this.currentNumMembersWithOverMinQuotaPartitions = 0;
            this.assignment = new HashMap<String, ArrayList>(consumerToOwnedPartitions.keySet().stream().collect(Collectors.toMap(c -> c, c -> new ArrayList(this.maxQuota))));
            this.assignedPartitions = new ArrayList<TopicPartition>();
        }

        @Override
        Map<String, List<TopicPartition>> build() {
            if (log.isDebugEnabled()) {
                log.debug("Performing constrained assign with partitionsPerTopic: {}, currentAssignment: {}, rackInfo {}.", this.partitionsPerTopic, this.currentAssignment, this.rackInfo);
            }
            this.assignOwnedPartitions();
            List unassignedPartitions = this.getUnassignedPartitions(this.assignedPartitions);
            if (log.isDebugEnabled()) {
                log.debug("After reassigning previously owned partitions, unfilled members: {}, unassigned partitions: {}, current assignment: {}", this.unfilledMembersWithUnderMinQuotaPartitions, unassignedPartitions, this.assignment);
            }
            Collections.sort(this.unfilledMembersWithUnderMinQuotaPartitions);
            Collections.sort(this.unfilledMembersWithExactlyMinQuotaPartitions);
            unassignedPartitions = this.rackInfo.sortPartitionsByRackConsumers(unassignedPartitions);
            this.assignRackAwareRoundRobin(unassignedPartitions);
            this.assignRoundRobin(unassignedPartitions);
            this.verifyUnfilledMembers();
            log.info("Final assignment of partitions to consumers: \n{}", (Object)this.assignment);
            return this.assignment;
        }

        private void assignOwnedPartitions() {
            for (Map.Entry consumerEntry : this.currentAssignment.entrySet()) {
                String consumer = (String)consumerEntry.getKey();
                List ownedPartitions = ((List)consumerEntry.getValue()).stream().filter(tp -> !this.rackInfo.racksMismatch(consumer, tp)).collect(Collectors.toList());
                List<TopicPartition> consumerAssignment = this.assignment.get(consumer);
                for (TopicPartition doublyClaimedPartition : this.partitionsWithMultiplePreviousOwners) {
                    if (!ownedPartitions.contains(doublyClaimedPartition)) continue;
                    log.error("Found partition {} still claimed as owned by consumer {}, despite being claimed by multiple consumers already in the same generation. Removing it from the ownedPartitions", (Object)doublyClaimedPartition, (Object)consumer);
                    ownedPartitions.remove(doublyClaimedPartition);
                }
                if (ownedPartitions.size() < this.minQuota) {
                    if (ownedPartitions.size() > 0) {
                        consumerAssignment.addAll(ownedPartitions);
                        this.assignedPartitions.addAll(ownedPartitions);
                    }
                    this.unfilledMembersWithUnderMinQuotaPartitions.add(consumer);
                    continue;
                }
                if (ownedPartitions.size() >= this.maxQuota && this.currentNumMembersWithOverMinQuotaPartitions < this.expectedNumMembersWithOverMinQuotaPartitions) {
                    ++this.currentNumMembersWithOverMinQuotaPartitions;
                    if (this.currentNumMembersWithOverMinQuotaPartitions == this.expectedNumMembersWithOverMinQuotaPartitions) {
                        this.unfilledMembersWithExactlyMinQuotaPartitions.clear();
                    }
                    List maxQuotaPartitions = ownedPartitions.subList(0, this.maxQuota);
                    consumerAssignment.addAll(maxQuotaPartitions);
                    this.assignedPartitions.addAll(maxQuotaPartitions);
                    this.allRevokedPartitions.addAll(ownedPartitions.subList(this.maxQuota, ownedPartitions.size()));
                    continue;
                }
                List minQuotaPartitions = ownedPartitions.subList(0, this.minQuota);
                consumerAssignment.addAll(minQuotaPartitions);
                this.assignedPartitions.addAll(minQuotaPartitions);
                this.allRevokedPartitions.addAll(ownedPartitions.subList(this.minQuota, ownedPartitions.size()));
                if (this.currentNumMembersWithOverMinQuotaPartitions >= this.expectedNumMembersWithOverMinQuotaPartitions) continue;
                this.unfilledMembersWithExactlyMinQuotaPartitions.add(consumer);
            }
        }

        private void assignRackAwareRoundRobin(List<TopicPartition> unassignedPartitions) {
            if (this.rackInfo.consumerRacks.isEmpty()) {
                return;
            }
            int nextUnfilledConsumerIndex = 0;
            Iterator<TopicPartition> unassignedIter = unassignedPartitions.iterator();
            while (unassignedIter.hasNext()) {
                int firstIndex;
                TopicPartition unassignedPartition = unassignedIter.next();
                String consumer = null;
                int nextIndex = this.rackInfo.nextRackConsumer(unassignedPartition, this.unfilledMembersWithUnderMinQuotaPartitions, nextUnfilledConsumerIndex);
                if (nextIndex >= 0) {
                    consumer = this.unfilledMembersWithUnderMinQuotaPartitions.get(nextIndex);
                    int assignmentCount = this.assignment.get(consumer).size() + 1;
                    if (assignmentCount >= this.minQuota) {
                        this.unfilledMembersWithUnderMinQuotaPartitions.remove(consumer);
                        if (assignmentCount < this.maxQuota) {
                            this.unfilledMembersWithExactlyMinQuotaPartitions.add(consumer);
                        }
                    } else {
                        ++nextIndex;
                    }
                    nextUnfilledConsumerIndex = this.unfilledMembersWithUnderMinQuotaPartitions.isEmpty() ? 0 : nextIndex % this.unfilledMembersWithUnderMinQuotaPartitions.size();
                } else if (!this.unfilledMembersWithExactlyMinQuotaPartitions.isEmpty() && (firstIndex = this.rackInfo.nextRackConsumer(unassignedPartition, this.unfilledMembersWithExactlyMinQuotaPartitions, 0)) >= 0 && this.assignment.get(consumer = this.unfilledMembersWithExactlyMinQuotaPartitions.get(firstIndex)).size() + 1 == this.maxQuota) {
                    this.unfilledMembersWithExactlyMinQuotaPartitions.remove(firstIndex);
                }
                if (consumer == null) continue;
                this.assignNewPartition(unassignedPartition, consumer);
                unassignedIter.remove();
            }
        }

        private void assignRoundRobin(List<TopicPartition> unassignedPartitions) {
            Iterator<String> unfilledConsumerIter = this.unfilledMembersWithUnderMinQuotaPartitions.iterator();
            for (TopicPartition unassignedPartition : unassignedPartitions) {
                String consumer;
                if (unfilledConsumerIter.hasNext()) {
                    consumer = unfilledConsumerIter.next();
                } else {
                    if (this.unfilledMembersWithUnderMinQuotaPartitions.isEmpty() && this.unfilledMembersWithExactlyMinQuotaPartitions.isEmpty()) {
                        int currentPartitionIndex = unassignedPartitions.indexOf(unassignedPartition);
                        log.error("No more unfilled consumers to be assigned. The remaining unassigned partitions are: {}", (Object)unassignedPartitions.subList(currentPartitionIndex, unassignedPartitions.size()));
                        throw new IllegalStateException("No more unfilled consumers to be assigned.");
                    }
                    if (this.unfilledMembersWithUnderMinQuotaPartitions.isEmpty()) {
                        consumer = this.unfilledMembersWithExactlyMinQuotaPartitions.poll();
                    } else {
                        unfilledConsumerIter = this.unfilledMembersWithUnderMinQuotaPartitions.iterator();
                        consumer = unfilledConsumerIter.next();
                    }
                }
                int currentAssignedCount = this.assignNewPartition(unassignedPartition, consumer);
                if (currentAssignedCount == this.minQuota) {
                    unfilledConsumerIter.remove();
                    this.unfilledMembersWithExactlyMinQuotaPartitions.add(consumer);
                    continue;
                }
                if (currentAssignedCount != this.maxQuota) continue;
                ++this.currentNumMembersWithOverMinQuotaPartitions;
                if (this.currentNumMembersWithOverMinQuotaPartitions != this.expectedNumMembersWithOverMinQuotaPartitions || unassignedPartitions.indexOf(unassignedPartition) == unassignedPartitions.size() - 1) continue;
                log.error("Filled the last member up to maxQuota but still had partitions remaining to assign, will continue but this indicates a bug in the assignment.");
            }
        }

        private int assignNewPartition(TopicPartition unassignedPartition, String consumer) {
            List<TopicPartition> consumerAssignment = this.assignment.get(consumer);
            consumerAssignment.add(unassignedPartition);
            if (this.allRevokedPartitions.contains(unassignedPartition) || this.partitionsWithMultiplePreviousOwners.contains(unassignedPartition)) {
                AbstractStickyAssignor.this.partitionsTransferringOwnership.put(unassignedPartition, consumer);
            }
            return consumerAssignment.size();
        }

        private void verifyUnfilledMembers() {
            if (!this.unfilledMembersWithUnderMinQuotaPartitions.isEmpty()) {
                if (this.currentNumMembersWithOverMinQuotaPartitions != this.expectedNumMembersWithOverMinQuotaPartitions) {
                    log.error("Current number of members with more than the minQuota partitions: {}, is less than the expected number of members with more than the minQuota partitions: {}, and no more partitions to be assigned to the remaining unfilled consumers: {}", this.currentNumMembersWithOverMinQuotaPartitions, this.expectedNumMembersWithOverMinQuotaPartitions, this.unfilledMembersWithUnderMinQuotaPartitions);
                    throw new IllegalStateException("We haven't reached the expected number of members with more than the minQuota partitions, but no more partitions to be assigned");
                }
                for (String unfilledMember : this.unfilledMembersWithUnderMinQuotaPartitions) {
                    int assignedPartitionsCount = this.assignment.get(unfilledMember).size();
                    if (assignedPartitionsCount != this.minQuota) {
                        log.error("Consumer: [{}] should have {} partitions, but got {} partitions, and no more partitions to be assigned. The remaining unfilled consumers are: {}", unfilledMember, this.minQuota, assignedPartitionsCount, this.unfilledMembersWithUnderMinQuotaPartitions);
                        throw new IllegalStateException(String.format("Consumer: [%s] doesn't reach minQuota partitions, and no more partitions to be assigned", unfilledMember));
                    }
                    log.trace("skip over this unfilled member: [{}] because we've reached the expected number of members with more than the minQuota partitions, and this member already has minQuota partitions", (Object)unfilledMember);
                }
            }
        }

        private List<TopicPartition> getUnassignedPartitions(List<TopicPartition> sortedAssignedPartitions) {
            ArrayList<String> sortedAllTopics = new ArrayList<String>(this.partitionsPerTopic.keySet());
            Collections.sort(sortedAllTopics);
            if (sortedAssignedPartitions.isEmpty()) {
                return this.getAllTopicPartitions(sortedAllTopics);
            }
            ArrayList<TopicPartition> unassignedPartitions = new ArrayList<TopicPartition>(this.totalPartitionsCount - sortedAssignedPartitions.size());
            Collections.sort(sortedAssignedPartitions, Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition));
            boolean shouldAddDirectly = false;
            Iterator<TopicPartition> sortedAssignedPartitionsIter = sortedAssignedPartitions.iterator();
            TopicPartition nextAssignedPartition = sortedAssignedPartitionsIter.next();
            for (String topic : sortedAllTopics) {
                int partitionCount = ((List)this.partitionsPerTopic.get(topic)).size();
                for (int i = 0; i < partitionCount; ++i) {
                    if (shouldAddDirectly || !nextAssignedPartition.topic().equals(topic) || nextAssignedPartition.partition() != i) {
                        unassignedPartitions.add(new TopicPartition(topic, i));
                        continue;
                    }
                    if (sortedAssignedPartitionsIter.hasNext()) {
                        nextAssignedPartition = sortedAssignedPartitionsIter.next();
                        continue;
                    }
                    shouldAddDirectly = true;
                }
            }
            return unassignedPartitions;
        }
    }

    private abstract class AbstractAssignmentBuilder {
        final Map<String, List<PartitionInfo>> partitionsPerTopic;
        final RackInfo rackInfo;
        final Map<String, List<TopicPartition>> currentAssignment;
        final int totalPartitionsCount;

        AbstractAssignmentBuilder(Map<String, List<PartitionInfo>> partitionsPerTopic, RackInfo rackInfo, Map<String, List<TopicPartition>> currentAssignment) {
            this.partitionsPerTopic = partitionsPerTopic;
            this.currentAssignment = currentAssignment;
            this.rackInfo = rackInfo;
            this.totalPartitionsCount = partitionsPerTopic.values().stream().map(List::size).reduce(0, Integer::sum);
        }

        abstract Map<String, List<TopicPartition>> build();

        protected List<TopicPartition> getAllTopicPartitions(List<String> sortedAllTopics) {
            ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>(this.totalPartitionsCount);
            for (String topic : sortedAllTopics) {
                this.partitionsPerTopic.get(topic).forEach(p -> allPartitions.add(new TopicPartition(p.topic(), p.partition())));
            }
            return allPartitions;
        }
    }

    private class RackInfo {
        private final Map<String, String> consumerRacks;
        private final Map<TopicPartition, Set<String>> partitionRacks;
        private final Map<TopicPartition, Integer> numConsumersByPartition;

        public RackInfo(List<PartitionInfo> partitionInfos, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
            Map<TopicPartition, Set<String>> partitionRacks;
            Map partitionsByRack;
            ArrayList<ConsumerPartitionAssignor.Subscription> consumers = new ArrayList<ConsumerPartitionAssignor.Subscription>(subscriptions.values());
            HashMap<String, List> consumersByRack = new HashMap<String, List>();
            subscriptions.forEach((memberId, subscription) -> subscription.rackId().filter(r -> !r.isEmpty()).ifPresent(rackId -> AbstractPartitionAssignor.put(consumersByRack, rackId, memberId)));
            if (consumersByRack.isEmpty()) {
                partitionsByRack = Collections.emptyMap();
                partitionRacks = Collections.emptyMap();
            } else {
                partitionRacks = new HashMap(partitionInfos.size());
                partitionsByRack = new HashMap();
                partitionInfos.forEach(p -> {
                    TopicPartition tp = new TopicPartition(p.topic(), p.partition());
                    HashSet racks = new HashSet(p.replicas().length);
                    partitionRacks.put(tp, racks);
                    Arrays.stream(p.replicas()).map(Node::rack).filter(Objects::nonNull).distinct().forEach(rackId -> {
                        AbstractPartitionAssignor.put(partitionsByRack, rackId, tp);
                        racks.add(rackId);
                    });
                });
            }
            if (AbstractStickyAssignor.this.useRackAwareAssignment(consumersByRack.keySet(), partitionsByRack.keySet(), partitionRacks)) {
                this.consumerRacks = new HashMap<String, String>(consumers.size());
                consumersByRack.forEach((rack, rackConsumers) -> rackConsumers.forEach(c -> this.consumerRacks.put((String)c, (String)rack)));
                this.partitionRacks = partitionRacks;
            } else {
                this.consumerRacks = Collections.emptyMap();
                this.partitionRacks = Collections.emptyMap();
            }
            this.numConsumersByPartition = partitionRacks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(r -> consumersByRack.getOrDefault(r, Collections.emptyList()).size()).reduce(0, Integer::sum)));
        }

        private boolean racksMismatch(String consumer, TopicPartition tp) {
            String consumerRack = this.consumerRacks.get(consumer);
            Set<String> replicaRacks = this.partitionRacks.get(tp);
            return consumerRack != null && (replicaRacks == null || !replicaRacks.contains(consumerRack));
        }

        private List<TopicPartition> sortPartitionsByRackConsumers(List<TopicPartition> partitions) {
            if (this.numConsumersByPartition.isEmpty()) {
                return partitions;
            }
            LinkedList<TopicPartition> sortedPartitions = new LinkedList<TopicPartition>(partitions);
            sortedPartitions.sort(Comparator.comparing(tp -> this.numConsumersByPartition.getOrDefault(tp, 0)));
            return sortedPartitions;
        }

        private int nextRackConsumer(TopicPartition tp, List<String> consumerList, int firstIndex) {
            Set<String> racks = this.partitionRacks.get(tp);
            if (racks == null || racks.isEmpty()) {
                return -1;
            }
            for (int i = 0; i < consumerList.size(); ++i) {
                int index = (firstIndex + i) % consumerList.size();
                String consumer = consumerList.get(index);
                String consumerRack = this.consumerRacks.get(consumer);
                if (consumerRack == null || !racks.contains(consumerRack)) continue;
                return index;
            }
            return -1;
        }

        public String toString() {
            return "RackInfo(consumerRacks=" + this.consumerRacks + ", partitionRacks=" + this.partitionRacks + ")";
        }
    }

    private static class ConsumerPair {
        private final String srcMemberId;
        private final String dstMemberId;

        ConsumerPair(String srcMemberId, String dstMemberId) {
            this.srcMemberId = srcMemberId;
            this.dstMemberId = dstMemberId;
        }

        public String toString() {
            return this.srcMemberId + "->" + this.dstMemberId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.srcMemberId == null ? 0 : this.srcMemberId.hashCode());
            result = 31 * result + (this.dstMemberId == null ? 0 : this.dstMemberId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            ConsumerPair otherPair = (ConsumerPair)obj;
            return this.srcMemberId.equals(otherPair.srcMemberId) && this.dstMemberId.equals(otherPair.dstMemberId);
        }

        private boolean in(Set<ConsumerPair> pairs) {
            for (ConsumerPair pair : pairs) {
                if (!this.equals(pair)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PartitionMovements {
        private final Map<String, Map<ConsumerPair, Set<TopicPartition>>> partitionMovementsByTopic = new HashMap<String, Map<ConsumerPair, Set<TopicPartition>>>();
        private final Map<TopicPartition, ConsumerPair> partitionMovements = new HashMap<TopicPartition, ConsumerPair>();

        private PartitionMovements() {
        }

        private ConsumerPair removeMovementRecordOfPartition(TopicPartition partition) {
            ConsumerPair pair = this.partitionMovements.remove(partition);
            String topic = partition.topic();
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic);
            partitionMovementsForThisTopic.get(pair).remove(partition);
            if (partitionMovementsForThisTopic.get(pair).isEmpty()) {
                partitionMovementsForThisTopic.remove(pair);
            }
            if (this.partitionMovementsByTopic.get(topic).isEmpty()) {
                this.partitionMovementsByTopic.remove(topic);
            }
            return pair;
        }

        private void addPartitionMovementRecord(TopicPartition partition, ConsumerPair pair) {
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic;
            this.partitionMovements.put(partition, pair);
            String topic = partition.topic();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                this.partitionMovementsByTopic.put(topic, new HashMap());
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(pair)) {
                partitionMovementsForThisTopic.put(pair, new HashSet());
            }
            partitionMovementsForThisTopic.get(pair).add(partition);
        }

        private void movePartition(TopicPartition partition, String oldConsumer, String newConsumer) {
            ConsumerPair pair = new ConsumerPair(oldConsumer, newConsumer);
            if (this.partitionMovements.containsKey(partition)) {
                ConsumerPair existingPair = this.removeMovementRecordOfPartition(partition);
                assert (existingPair.dstMemberId.equals(oldConsumer));
                if (!existingPair.srcMemberId.equals(newConsumer)) {
                    this.addPartitionMovementRecord(partition, new ConsumerPair(existingPair.srcMemberId, newConsumer));
                }
            } else {
                this.addPartitionMovementRecord(partition, pair);
            }
        }

        private TopicPartition getTheActualPartitionToBeMoved(TopicPartition partition, String oldConsumer, String newConsumer) {
            ConsumerPair reversePair;
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic;
            String topic = partition.topic();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                return partition;
            }
            if (this.partitionMovements.containsKey(partition)) {
                assert (oldConsumer.equals(this.partitionMovements.get(partition).dstMemberId));
                oldConsumer = this.partitionMovements.get(partition).srcMemberId;
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(reversePair = new ConsumerPair(newConsumer, oldConsumer))) {
                return partition;
            }
            return partitionMovementsForThisTopic.get(reversePair).iterator().next();
        }

        private boolean isLinked(String src, String dst, Set<ConsumerPair> pairs, List<String> currentPath) {
            if (src.equals(dst)) {
                return false;
            }
            if (pairs.isEmpty()) {
                return false;
            }
            if (new ConsumerPair(src, dst).in(pairs)) {
                currentPath.add(src);
                currentPath.add(dst);
                return true;
            }
            for (ConsumerPair pair : pairs) {
                if (!pair.srcMemberId.equals(src)) continue;
                HashSet<ConsumerPair> reducedSet = new HashSet<ConsumerPair>(pairs);
                reducedSet.remove(pair);
                currentPath.add(pair.srcMemberId);
                return this.isLinked(pair.dstMemberId, dst, reducedSet, currentPath);
            }
            return false;
        }

        private boolean in(List<String> cycle, Set<List<String>> cycles) {
            ArrayList<String> superCycle = new ArrayList<String>(cycle);
            superCycle.remove(superCycle.size() - 1);
            superCycle.addAll(cycle);
            for (List<String> foundCycle : cycles) {
                if (foundCycle.size() != cycle.size() || Collections.indexOfSubList(superCycle, foundCycle) == -1) continue;
                return true;
            }
            return false;
        }

        private boolean hasCycles(Set<ConsumerPair> pairs) {
            HashSet<List<String>> cycles = new HashSet<List<String>>();
            for (ConsumerPair consumerPair : pairs) {
                HashSet<ConsumerPair> reducedPairs = new HashSet<ConsumerPair>(pairs);
                reducedPairs.remove(consumerPair);
                ArrayList<String> path = new ArrayList<String>(Collections.singleton(consumerPair.srcMemberId));
                if (!this.isLinked(consumerPair.dstMemberId, consumerPair.srcMemberId, reducedPairs, path) || this.in(path, cycles)) continue;
                cycles.add(new ArrayList<String>(path));
                log.error("A cycle of length {} was found: {}", (Object)(path.size() - 1), (Object)path);
            }
            for (List list : cycles) {
                if (list.size() != 3) continue;
                return true;
            }
            return false;
        }

        private boolean isSticky() {
            for (Map.Entry<String, Map<ConsumerPair, Set<TopicPartition>>> topicMovements : this.partitionMovementsByTopic.entrySet()) {
                Set<ConsumerPair> topicMovementPairs = topicMovements.getValue().keySet();
                if (!this.hasCycles(topicMovementPairs)) continue;
                log.error("Stickiness is violated for topic {}\nPartition movements for this topic occurred among the following consumer pairs:\n{}", (Object)topicMovements.getKey(), (Object)topicMovements.getValue().toString());
                return false;
            }
            return true;
        }
    }

    private static class SubscriptionComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, List<TopicPartition>> map;

        SubscriptionComparator(Map<String, List<TopicPartition>> map) {
            this.map = map;
        }

        @Override
        public int compare(String o1, String o2) {
            int ret = this.map.get(o1).size() - this.map.get(o2).size();
            if (ret == 0) {
                ret = o1.compareTo(o2);
            }
            return ret;
        }
    }

    private static class TopicComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, List<String>> map;

        TopicComparator(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public int compare(String o1, String o2) {
            int ret = this.map.get(o1).size() - this.map.get(o2).size();
            if (ret == 0) {
                ret = o1.compareTo(o2);
            }
            return ret;
        }
    }

    public static final class MemberData {
        public final List<TopicPartition> partitions;
        public final Optional<Integer> generation;
        public final Optional<String> rackId;

        public MemberData(List<TopicPartition> partitions, Optional<Integer> generation, Optional<String> rackId) {
            this.partitions = partitions;
            this.generation = generation;
            this.rackId = rackId;
        }

        public MemberData(List<TopicPartition> partitions, Optional<Integer> generation) {
            this(partitions, generation, Optional.empty());
        }
    }

    static final class ConsumerGenerationPair {
        final String consumer;
        final int generation;

        ConsumerGenerationPair(String consumer, int generation) {
            this.consumer = consumer;
            this.generation = generation;
        }
    }
}

