/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.util.AsciiString;
import io.netty.util.NetUtil;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ForwardedParser {
    private static final Logger LOG = LoggerFactory.getLogger(RouterImpl.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final AsciiString FORWARDED = AsciiString.cached("Forwarded");
    private static final AsciiString X_FORWARDED_SSL = AsciiString.cached("X-Forwarded-Ssl");
    private static final AsciiString X_FORWARDED_PROTO = AsciiString.cached("X-Forwarded-Proto");
    private static final AsciiString X_FORWARDED_HOST = AsciiString.cached("X-Forwarded-Host");
    private static final AsciiString X_FORWARDED_PORT = AsciiString.cached("X-Forwarded-Port");
    private static final AsciiString X_FORWARDED_FOR = AsciiString.cached("X-Forwarded-For");
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?", 2);
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?", 2);
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?", 2);
    private final HttpServerRequest delegate;
    private final AllowForwardHeaders allowForward;
    private boolean calculated;
    private HostAndPort authority;
    private String host;
    private int port = -1;
    private String scheme;
    private String absoluteURI;
    private SocketAddress remoteAddress;

    ForwardedParser(HttpServerRequest delegate, AllowForwardHeaders allowForward) {
        this.delegate = delegate;
        this.allowForward = allowForward;
    }

    public String scheme() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme;
    }

    String host() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.host;
    }

    HostAndPort authority() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.authority;
    }

    boolean isSSL() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme.equals(HTTPS_SCHEME);
    }

    String absoluteURI() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.absoluteURI;
    }

    SocketAddress remoteAddress() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.remoteAddress;
    }

    private void calculate() {
        this.calculated = true;
        this.remoteAddress = this.delegate.remoteAddress();
        this.scheme = this.delegate.scheme();
        this.setHostAndPort(this.delegate.authority());
        switch (this.allowForward) {
            case X_FORWARD: {
                this.calculateXForward();
                break;
            }
            case FORWARD: {
                this.calculateForward();
                break;
            }
            case ALL: {
                this.calculateXForward();
                this.calculateForward();
                break;
            }
        }
        if (this.scheme.equalsIgnoreCase(HTTP_SCHEME) && this.port == 80 || this.scheme.equalsIgnoreCase(HTTPS_SCHEME) && this.port == 443) {
            this.port = -1;
        }
        if (this.host != null) {
            this.authority = HostAndPort.create(this.host, this.port);
            this.host = this.host + (this.port >= 0 ? ":" + this.port : "");
            this.absoluteURI = this.scheme + "://" + this.host + this.delegate.uri();
        }
    }

    private void calculateForward() {
        String forwarded = this.delegate.getHeader(FORWARDED);
        if (forwarded != null) {
            String forwardedToUse = forwarded.split(",")[0];
            Matcher matcher = FORWARDED_PROTO_PATTERN.matcher(forwardedToUse);
            if (matcher.find()) {
                this.scheme = matcher.group(1).trim();
                this.port = -1;
            }
            if ((matcher = FORWARDED_HOST_PATTERN.matcher(forwardedToUse)).find()) {
                this.setHostAndPort(HostAndPort.parseAuthority(matcher.group(1).trim(), -1));
            }
            if ((matcher = FORWARDED_FOR_PATTERN.matcher(forwardedToUse)).find()) {
                this.remoteAddress = this.parseFor(matcher.group(1).trim(), this.remoteAddress.port());
            }
        }
    }

    private void calculateXForward() {
        String forHeader;
        String portHeader;
        String forwardedSsl = this.delegate.getHeader(X_FORWARDED_SSL);
        boolean isForwardedSslOn = forwardedSsl != null && forwardedSsl.equalsIgnoreCase("on");
        String protocolHeader = this.delegate.getHeader(X_FORWARDED_PROTO);
        if (protocolHeader != null) {
            this.scheme = protocolHeader.split(",")[0];
            this.port = -1;
        } else if (isForwardedSslOn) {
            this.scheme = HTTPS_SCHEME;
            this.port = -1;
        }
        String hostHeader = this.delegate.getHeader(X_FORWARDED_HOST);
        if (hostHeader != null) {
            this.setHostAndPort(HostAndPort.parseAuthority(hostHeader.split(",")[0], -1));
        }
        if ((portHeader = this.delegate.getHeader(X_FORWARDED_PORT)) != null) {
            this.port = this.parsePort(portHeader.split(",")[0], this.port);
        }
        if ((forHeader = this.delegate.getHeader(X_FORWARDED_FOR)) != null) {
            this.remoteAddress = this.parseFor(forHeader.split(",")[0], this.remoteAddress.port());
        }
    }

    private void setHostAndPort(HostAndPort authority) {
        if (authority == null) {
            this.host = null;
            this.port = -1;
        } else {
            String h;
            this.host = h = authority.host();
            this.port = authority.port();
        }
    }

    private SocketAddress parseFor(String forToParse, int defaultPort) {
        int portSeparatorIdx;
        String host = forToParse;
        int port = defaultPort;
        if (forToParse.length() > 0 && forToParse.charAt(0) == '[') {
            int portSeparatorIdx2;
            int idx = forToParse.lastIndexOf("]");
            if (idx > 0 && (portSeparatorIdx2 = forToParse.indexOf(58, idx + 1)) > 0) {
                host = forToParse.substring(0, idx + 1);
                port = this.parsePort(forToParse.substring(idx + 2), defaultPort);
            }
        } else if (!NetUtil.isValidIpV6Address(forToParse) && (portSeparatorIdx = forToParse.lastIndexOf(58)) > 0) {
            host = forToParse.substring(0, portSeparatorIdx);
            port = this.parsePort(forToParse.substring(portSeparatorIdx + 1), defaultPort);
        }
        return new SocketAddressImpl(port, host);
    }

    private int parsePort(String portToParse, int defaultPort) {
        try {
            return Integer.parseInt(portToParse);
        }
        catch (NumberFormatException ignored) {
            LOG.error("Failed to parse a port from \"forwarded\"-type headers.");
            return defaultPort;
        }
    }
}

