/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersion;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersionBuilder;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersionFluent;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionCondition;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionConditionBuilder;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionConditionFluent;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StorageVersionStatusFluent<A extends StorageVersionStatusFluent<A>>
extends BaseFluent<A> {
    private String commonEncodingVersion;
    private ArrayList<StorageVersionConditionBuilder> conditions = new ArrayList();
    private ArrayList<ServerStorageVersionBuilder> storageVersions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public StorageVersionStatusFluent() {
    }

    public StorageVersionStatusFluent(StorageVersionStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StorageVersionStatus instance) {
        StorageVersionStatus storageVersionStatus = instance = instance != null ? instance : new StorageVersionStatus();
        if (instance != null) {
            this.withCommonEncodingVersion(instance.getCommonEncodingVersion());
            this.withConditions(instance.getConditions());
            this.withStorageVersions(instance.getStorageVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCommonEncodingVersion() {
        return this.commonEncodingVersion;
    }

    public A withCommonEncodingVersion(String commonEncodingVersion) {
        this.commonEncodingVersion = commonEncodingVersion;
        return (A)this;
    }

    public boolean hasCommonEncodingVersion() {
        return this.commonEncodingVersion != null;
    }

    public A addToConditions(int index, StorageVersionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, StorageVersionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(StorageVersionCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (StorageVersionCondition item : items) {
            StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<StorageVersionCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (StorageVersionCondition item : items) {
            StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(StorageVersionCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (StorageVersionCondition item : items) {
            StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<StorageVersionCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (StorageVersionCondition item : items) {
            StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<StorageVersionConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<StorageVersionConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            StorageVersionConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<StorageVersionCondition> buildConditions() {
        return this.conditions != null ? StorageVersionStatusFluent.build(this.conditions) : null;
    }

    public StorageVersionCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public StorageVersionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public StorageVersionCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public StorageVersionCondition buildMatchingCondition(Predicate<StorageVersionConditionBuilder> predicate) {
        for (StorageVersionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<StorageVersionConditionBuilder> predicate) {
        for (StorageVersionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<StorageVersionCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (StorageVersionCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(StorageVersionCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (StorageVersionCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(StorageVersionCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, StorageVersionCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<StorageVersionConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToStorageVersions(int index, ServerStorageVersion item) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
        if (index < 0 || index >= this.storageVersions.size()) {
            this._visitables.get("storageVersions").add(builder);
            this.storageVersions.add(builder);
        } else {
            this._visitables.get("storageVersions").add(index, builder);
            this.storageVersions.add(index, builder);
        }
        return (A)this;
    }

    public A setToStorageVersions(int index, ServerStorageVersion item) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
        if (index < 0 || index >= this.storageVersions.size()) {
            this._visitables.get("storageVersions").add(builder);
            this.storageVersions.add(builder);
        } else {
            this._visitables.get("storageVersions").set(index, builder);
            this.storageVersions.set(index, builder);
        }
        return (A)this;
    }

    public A addToStorageVersions(ServerStorageVersion ... items) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        for (ServerStorageVersion item : items) {
            ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").add(builder);
            this.storageVersions.add(builder);
        }
        return (A)this;
    }

    public A addAllToStorageVersions(Collection<ServerStorageVersion> items) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        for (ServerStorageVersion item : items) {
            ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").add(builder);
            this.storageVersions.add(builder);
        }
        return (A)this;
    }

    public A removeFromStorageVersions(ServerStorageVersion ... items) {
        if (this.storageVersions == null) {
            return (A)this;
        }
        for (ServerStorageVersion item : items) {
            ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").remove(builder);
            this.storageVersions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromStorageVersions(Collection<ServerStorageVersion> items) {
        if (this.storageVersions == null) {
            return (A)this;
        }
        for (ServerStorageVersion item : items) {
            ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").remove(builder);
            this.storageVersions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromStorageVersions(Predicate<ServerStorageVersionBuilder> predicate) {
        if (this.storageVersions == null) {
            return (A)this;
        }
        Iterator<ServerStorageVersionBuilder> each = this.storageVersions.iterator();
        Object visitables = this._visitables.get("storageVersions");
        while (each.hasNext()) {
            ServerStorageVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ServerStorageVersion> buildStorageVersions() {
        return this.storageVersions != null ? StorageVersionStatusFluent.build(this.storageVersions) : null;
    }

    public ServerStorageVersion buildStorageVersion(int index) {
        return this.storageVersions.get(index).build();
    }

    public ServerStorageVersion buildFirstStorageVersion() {
        return this.storageVersions.get(0).build();
    }

    public ServerStorageVersion buildLastStorageVersion() {
        return this.storageVersions.get(this.storageVersions.size() - 1).build();
    }

    public ServerStorageVersion buildMatchingStorageVersion(Predicate<ServerStorageVersionBuilder> predicate) {
        for (ServerStorageVersionBuilder item : this.storageVersions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStorageVersion(Predicate<ServerStorageVersionBuilder> predicate) {
        for (ServerStorageVersionBuilder item : this.storageVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStorageVersions(List<ServerStorageVersion> storageVersions) {
        if (this.storageVersions != null) {
            this._visitables.get("storageVersions").clear();
        }
        if (storageVersions != null) {
            this.storageVersions = new ArrayList();
            for (ServerStorageVersion item : storageVersions) {
                this.addToStorageVersions(item);
            }
        } else {
            this.storageVersions = null;
        }
        return (A)this;
    }

    public A withStorageVersions(ServerStorageVersion ... storageVersions) {
        if (this.storageVersions != null) {
            this.storageVersions.clear();
            this._visitables.remove("storageVersions");
        }
        if (storageVersions != null) {
            for (ServerStorageVersion item : storageVersions) {
                this.addToStorageVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasStorageVersions() {
        return this.storageVersions != null && !this.storageVersions.isEmpty();
    }

    public StorageVersionsNested<A> addNewStorageVersion() {
        return new StorageVersionsNested(-1, null);
    }

    public StorageVersionsNested<A> addNewStorageVersionLike(ServerStorageVersion item) {
        return new StorageVersionsNested(-1, item);
    }

    public StorageVersionsNested<A> setNewStorageVersionLike(int index, ServerStorageVersion item) {
        return new StorageVersionsNested(index, item);
    }

    public StorageVersionsNested<A> editStorageVersion(int index) {
        if (this.storageVersions.size() <= index) {
            throw new RuntimeException("Can't edit storageVersions. Index exceeds size.");
        }
        return this.setNewStorageVersionLike(index, this.buildStorageVersion(index));
    }

    public StorageVersionsNested<A> editFirstStorageVersion() {
        if (this.storageVersions.size() == 0) {
            throw new RuntimeException("Can't edit first storageVersions. The list is empty.");
        }
        return this.setNewStorageVersionLike(0, this.buildStorageVersion(0));
    }

    public StorageVersionsNested<A> editLastStorageVersion() {
        int index = this.storageVersions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last storageVersions. The list is empty.");
        }
        return this.setNewStorageVersionLike(index, this.buildStorageVersion(index));
    }

    public StorageVersionsNested<A> editMatchingStorageVersion(Predicate<ServerStorageVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.storageVersions.size(); ++i) {
            if (!predicate.test(this.storageVersions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching storageVersions. No match found.");
        }
        return this.setNewStorageVersionLike(index, this.buildStorageVersion(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageVersionStatusFluent that = (StorageVersionStatusFluent)o;
        if (!Objects.equals(this.commonEncodingVersion, that.commonEncodingVersion)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.storageVersions, that.storageVersions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.commonEncodingVersion, this.conditions, this.storageVersions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commonEncodingVersion != null) {
            sb.append("commonEncodingVersion:");
            sb.append(this.commonEncodingVersion + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.storageVersions != null && !this.storageVersions.isEmpty()) {
            sb.append("storageVersions:");
            sb.append(this.storageVersions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StorageVersionsNested<N>
    extends ServerStorageVersionFluent<StorageVersionsNested<N>>
    implements Nested<N> {
        ServerStorageVersionBuilder builder;
        int index;

        StorageVersionsNested(int index, ServerStorageVersion item) {
            this.index = index;
            this.builder = new ServerStorageVersionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StorageVersionStatusFluent.this.setToStorageVersions(this.index, this.builder.build());
        }

        public N endStorageVersion() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends StorageVersionConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        StorageVersionConditionBuilder builder;
        int index;

        ConditionsNested(int index, StorageVersionCondition item) {
            this.index = index;
            this.builder = new StorageVersionConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StorageVersionStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

