/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.config;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.ServiceOptions;

public class ServiceConfigProperties
extends ServerConfig {
    public static final int DEFAULT_MAX_PAYLOAD_SIZE = 2048;
    public static final int DEFAULT_RECEIVER_LINK_CREDITS = 100;
    public static final long DEFAULT_SEND_TIMEOUT_IN_MS = 3000L;
    public static final long MIN_SEND_TIMEOUT_IN_MS = 500L;
    private static final int MIN_PAYLOAD_SIZE = 128;
    private long eventLoopBlockedCheckTimeout = 5000L;
    private boolean networkDebugLoggingEnabled = false;
    private boolean waitForDownstreamConnectionEnabled = false;
    private int maxPayloadSize = 2048;
    private int receiverLinkCredit = 100;
    private String corsAllowedOrigin = "*";
    private long sendTimeOut = 3000L;
    private Pattern tenantIdPattern = Pattern.compile("^[a-zA-Z0-9-_\\.]+$");
    private Pattern deviceIdPattern = Pattern.compile("^[a-zA-Z0-9-_\\.:=]+$");

    public ServiceConfigProperties() {
    }

    public ServiceConfigProperties(ServiceOptions options) {
        super(options.serverOptions());
        this.setCorsAllowedOrigin(options.corsAllowedOrigin());
        this.setDeviceIdPattern(options.deviceIdPattern());
        this.setEventLoopBlockedCheckTimeout(options.eventLoopBlockedCheckTimeout());
        this.setMaxPayloadSize(options.maxPayloadSize());
        this.setNetworkDebugLoggingEnabled(options.networkDebugLoggingEnabled());
        this.setReceiverLinkCredit(options.receiverLinkCredit());
        this.setSendTimeOut(options.sendTimeOut());
        this.setTenantIdPattern(options.tenantIdPattern());
        this.setWaitForDownstreamConnectionEnabled(options.waitForDownstreamConnectionEnabled());
    }

    public final void setMaxPayloadSize(int bytes) {
        if (bytes <= 128) {
            throw new IllegalArgumentException("minimum message payload size is 128 bytes");
        }
        this.maxPayloadSize = bytes;
    }

    public final int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public final boolean isNetworkDebugLoggingEnabled() {
        return this.networkDebugLoggingEnabled;
    }

    public final ServiceConfigProperties setNetworkDebugLoggingEnabled(boolean networkDebugLoggingEnabled) {
        this.networkDebugLoggingEnabled = networkDebugLoggingEnabled;
        return this;
    }

    public final boolean isWaitForDownstreamConnectionEnabled() {
        return this.waitForDownstreamConnectionEnabled;
    }

    public final ServiceConfigProperties setWaitForDownstreamConnectionEnabled(boolean waitForConnection) {
        this.waitForDownstreamConnectionEnabled = waitForConnection;
        return this;
    }

    public final int getReceiverLinkCredit() {
        return this.receiverLinkCredit;
    }

    public final void setReceiverLinkCredit(int receiverLinkCredit) {
        if (receiverLinkCredit <= 0) {
            throw new IllegalArgumentException("receiver link credit must be at least 1");
        }
        this.receiverLinkCredit = receiverLinkCredit;
    }

    public final String getCorsAllowedOrigin() {
        return this.corsAllowedOrigin;
    }

    public final void setCorsAllowedOrigin(String corsAllowedOrigin) {
        this.corsAllowedOrigin = Objects.requireNonNull(corsAllowedOrigin);
    }

    public final long getSendTimeOut() {
        return this.sendTimeOut;
    }

    public final void setSendTimeOut(long sendTimeOutInMs) {
        if (sendTimeOutInMs < 500L) {
            throw new IllegalArgumentException(String.format("send time out value must be >= %sms", 500L));
        }
        this.sendTimeOut = sendTimeOutInMs;
    }

    public final Pattern getDeviceIdPattern() {
        return this.deviceIdPattern;
    }

    public final void setDeviceIdPattern(String regex) {
        this.deviceIdPattern = Pattern.compile(Objects.requireNonNull(regex));
    }

    public final Pattern getTenantIdPattern() {
        return this.tenantIdPattern;
    }

    public final void setTenantIdPattern(String regex) {
        this.tenantIdPattern = Pattern.compile(Objects.requireNonNull(regex));
    }

    public final long getEventLoopBlockedCheckTimeout() {
        return this.eventLoopBlockedCheckTimeout;
    }

    public final void setEventLoopBlockedCheckTimeout(long eventLoopBlockedCheckTimeout) {
        this.eventLoopBlockedCheckTimeout = eventLoopBlockedCheckTimeout;
    }
}

