/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Future;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.impl.RoutingContextImplBase;

public class FileUploadImpl
implements FileUpload {
    private final FileSystem fs;
    private final String uploadedFileName;
    private final HttpServerFileUpload upload;

    public FileUploadImpl(FileSystem fs, String uploadedFileName, HttpServerFileUpload upload) {
        this.fs = fs;
        this.uploadedFileName = uploadedFileName;
        this.upload = upload;
    }

    @Override
    public String name() {
        return this.upload.name();
    }

    @Override
    public String uploadedFileName() {
        return this.uploadedFileName;
    }

    @Override
    public String fileName() {
        return this.upload.filename();
    }

    @Override
    public long size() {
        return this.upload.size();
    }

    @Override
    public String contentType() {
        return this.upload.contentType();
    }

    @Override
    public String contentTransferEncoding() {
        return this.upload.contentTransferEncoding();
    }

    @Override
    public String charSet() {
        return this.upload.charset();
    }

    @Override
    public boolean cancel() {
        return this.upload.cancelStreamToFileSystem();
    }

    @Override
    public Future<Void> delete() {
        String uploadedFileName = this.uploadedFileName();
        return this.fs.delete(uploadedFileName).onFailure(err -> RoutingContextImplBase.LOG.warn("Delete of uploaded file failed: " + uploadedFileName, (Throwable)err));
    }
}

