/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigProducerUtil;
import io.smallrye.config.inject.InjectionMessages;
import io.smallrye.config.inject.MetadataInjectionPoint;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigInjectionBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    private final BeanManager bm;
    private final Class<?> clazz;
    private Config _config;

    public ConfigInjectionBean(BeanManager bm, Class<?> clazz) {
        this.bm = bm;
        this.clazz = clazz;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public Class<?> getBeanClass() {
        return ConfigInjectionBean.class;
    }

    @Override
    public T create(CreationalContext<T> context) {
        InjectionPoint ip = (InjectionPoint)this.bm.getInjectableReference(new MetadataInjectionPoint(), context);
        Annotated annotated = ip.getAnnotated();
        ConfigProperty configProperty = annotated.getAnnotation(ConfigProperty.class);
        String key = ConfigProducerUtil.getConfigKey(ip, configProperty);
        String defaultValue = configProperty.defaultValue();
        if (annotated.getBaseType() instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)annotated.getBaseType();
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class && (((Class)rawType).isAssignableFrom(Provider.class) || ((Class)rawType).isAssignableFrom(Instance.class)) && paramType.getActualTypeArguments().length == 1) {
                Class paramTypeClass = (Class)paramType.getActualTypeArguments()[0];
                return this.getConfig().getValue(key, paramTypeClass);
            }
        } else {
            Class annotatedTypeClass = (Class)annotated.getBaseType();
            if (defaultValue.length() == 0) {
                return this.getConfig().getValue(key, annotatedTypeClass);
            }
            Optional<Object> optionalValue = this.getConfig().getOptionalValue(key, annotatedTypeClass);
            return (T)optionalValue.orElseGet(() -> this.getConfig().unwrap(SmallRyeConfig.class).convert(defaultValue, annotatedTypeClass));
        }
        throw InjectionMessages.msg.unhandledConfigProperty();
    }

    public Config getConfig() {
        if (this._config == null) {
            this._config = ConfigProvider.getConfig();
        }
        return this._config;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> context) {
    }

    @Override
    public Set<Type> getTypes() {
        return Collections.singleton(this.clazz);
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    @Override
    public String getId() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    static {
        QUALIFIERS.add(new ConfigPropertyLiteral());
    }

    private static class ConfigPropertyLiteral
    extends AnnotationLiteral<ConfigProperty>
    implements ConfigProperty {
        private ConfigPropertyLiteral() {
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public String defaultValue() {
            return "";
        }
    }
}

