/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public final class Futures {
    private Futures() {
    }

    public static <T> Future<T> create(Supplier<CompletionStage<T>> futureSupplier) {
        CompletionStage<Object> future;
        Objects.requireNonNull(futureSupplier);
        Context originalContext = Vertx.currentContext();
        try {
            future = futureSupplier.get();
        }
        catch (Exception e2) {
            return Future.failedFuture(e2);
        }
        Promise result = Promise.promise();
        future.whenComplete((r, e) -> {
            Future<Object> asyncResult;
            Future<Object> future = asyncResult = e != null ? Future.failedFuture(e) : Future.succeededFuture(r);
            if (originalContext != null && originalContext != Vertx.currentContext()) {
                originalContext.runOnContext(go -> result.handle(asyncResult));
            } else {
                result.handle(asyncResult);
            }
        });
        return result.future();
    }

    public static <T> Future<T> executeBlocking(Vertx vertx, BlockingCode<T> blocking) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(blocking);
        Promise result = Promise.promise();
        vertx.executeBlocking(promise -> {
            try {
                promise.complete(blocking.run());
            }
            catch (Throwable e) {
                promise.fail(e);
            }
        }, result);
        return result.future();
    }

    public static <T> Future<T> executeOnContextWithSameRoot(Context requiredContextOrContextRoot, Handler<Promise<T>> codeToRun) {
        Objects.requireNonNull(requiredContextOrContextRoot);
        Objects.requireNonNull(codeToRun);
        Promise result = Promise.promise();
        if (Futures.isCurrentOrRootOfCurrentContext(requiredContextOrContextRoot)) {
            codeToRun.handle(result);
        } else {
            requiredContextOrContextRoot.runOnContext(go -> codeToRun.handle(result));
        }
        return result.future();
    }

    private static boolean isCurrentOrRootOfCurrentContext(Context context) {
        Objects.requireNonNull(context);
        return Optional.ofNullable(Vertx.currentContext()).map(currentContext -> context == currentContext || context == VertxContext.getRootContext(currentContext)).orElse(false);
    }

    public static <T> void tryHandleResult(Promise<T> promise, AsyncResult<T> asyncResult) {
        Objects.requireNonNull(promise);
        Objects.requireNonNull(asyncResult);
        if (asyncResult.succeeded()) {
            promise.tryComplete(asyncResult.result());
        } else {
            promise.tryFail(asyncResult.cause());
        }
    }

    public static <T> Handler<AsyncResult<T>> onCurrentContextCompletionHandler(Handler<AsyncResult<T>> handlerToComplete) {
        Objects.requireNonNull(handlerToComplete);
        Context context = Vertx.currentContext();
        if (context == null) {
            return handlerToComplete;
        }
        return ar -> context.runOnContext(v -> handlerToComplete.handle((AsyncResult)ar));
    }

    @FunctionalInterface
    public static interface BlockingCode<T> {
        public T run() throws Exception;
    }
}

