/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ResourceLimitExceededException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;

public final class ErrorConverter {
    private ErrorConverter() {
    }

    public static ServiceInvocationException fromTransferError(ErrorCondition error) {
        Objects.requireNonNull(error);
        return ErrorConverter.fromTransferError(error.getCondition(), error.getDescription());
    }

    public static ServiceInvocationException fromTransferError(Symbol condition, String description) {
        Objects.requireNonNull(condition);
        if (AmqpError.RESOURCE_LIMIT_EXCEEDED.equals(condition)) {
            return new ResourceLimitExceededException(description);
        }
        if (AmqpError.UNAUTHORIZED_ACCESS.equals(condition)) {
            return new ClientErrorException(403, description);
        }
        if (AmqpError.INTERNAL_ERROR.equals(condition)) {
            return new ServerErrorException(500, description);
        }
        return new ClientErrorException(400, description);
    }

    public static ServiceInvocationException fromAttachError(ErrorCondition error) {
        Objects.requireNonNull(error);
        return ErrorConverter.fromAttachError(error.getCondition(), error.getDescription());
    }

    public static ServiceInvocationException fromAttachError(Symbol condition, String description) {
        Objects.requireNonNull(condition);
        if (AmqpError.RESOURCE_LIMIT_EXCEEDED.equals(condition)) {
            return new ClientErrorException(403, description);
        }
        if (AmqpError.UNAUTHORIZED_ACCESS.equals(condition)) {
            return new ClientErrorException(403, description);
        }
        if (AmqpError.INTERNAL_ERROR.equals(condition)) {
            return new ServerErrorException(500, description);
        }
        if (AmqpUtils.AMQP_BAD_REQUEST.equals(condition)) {
            return new ClientErrorException(400, description);
        }
        return new ClientErrorException(404, description);
    }
}

