/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.CommandEndpoint;

@RegisterForReflection
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(content=JsonInclude.Include.NON_EMPTY)
public final class RegistrationAssertion {
    private final String deviceId;
    private List<String> authorizedGateways = new ArrayList<String>();
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private String downstreamMessageMapper;
    private String upstreamMessageMapper;
    private CommandEndpoint commandEndpoint;

    public RegistrationAssertion(@JsonProperty(value="device-id", required=true) String deviceId) {
        Objects.requireNonNull(deviceId);
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="via")
    public List<String> getAuthorizedGateways() {
        return this.authorizedGateways;
    }

    public RegistrationAssertion setAuthorizedGateways(List<String> gatewayIds) {
        this.authorizedGateways.clear();
        Optional.ofNullable(gatewayIds).ifPresent(this.authorizedGateways::addAll);
        return this;
    }

    @JsonProperty(value="downstream-message-mapper")
    public String getDownstreamMessageMapper() {
        return this.downstreamMessageMapper;
    }

    public RegistrationAssertion setDownstreamMessageMapper(String downstreamMessageMapper) {
        this.downstreamMessageMapper = downstreamMessageMapper;
        return this;
    }

    @JsonProperty(value="upstream-message-mapper")
    public String getUpstreamMessageMapper() {
        return this.upstreamMessageMapper;
    }

    public RegistrationAssertion setUpstreamMessageMapper(String upstreamMessageMapper) {
        this.upstreamMessageMapper = upstreamMessageMapper;
        return this;
    }

    @JsonProperty(value="defaults")
    public Map<String, Object> getDefaults() {
        return Collections.unmodifiableMap(this.defaults);
    }

    public RegistrationAssertion setDefaults(Map<String, Object> defaults) {
        this.defaults.clear();
        Optional.ofNullable(defaults).ifPresent(this.defaults::putAll);
        return this;
    }

    @JsonProperty(value="command-endpoint")
    public CommandEndpoint getCommandEndpoint() {
        return this.commandEndpoint;
    }

    public RegistrationAssertion setCommandEndpoint(CommandEndpoint commandEndpoint) {
        this.commandEndpoint = commandEndpoint;
        return this;
    }
}

