/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.impl.ForwardedParser;
import io.vertx.ext.web.impl.ServerWebSocketWrapper;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class HttpServerRequestWrapper
implements HttpServerRequestInternal {
    private final HttpServerRequestInternal delegate;
    private final ForwardedParser forwardedParser;
    private boolean modified;
    private HttpMethod method;
    private String path;
    private String query;
    private String uri;
    private String absoluteURI;
    private MultiMap params;

    HttpServerRequestWrapper(HttpServerRequest request, AllowForwardHeaders allowForward) {
        this.delegate = (HttpServerRequestInternal)request;
        this.forwardedParser = new ForwardedParser(this.delegate, allowForward);
    }

    void changeTo(HttpMethod method, String uri) {
        this.modified = true;
        this.method = method;
        this.uri = uri;
        this.query = null;
        this.absoluteURI = null;
        int queryIndex = uri.indexOf(63);
        if (queryIndex != -1) {
            int fragmentIndex = uri.indexOf(35, queryIndex);
            this.path = uri.substring(0, queryIndex);
            this.query = fragmentIndex != -1 ? uri.substring(queryIndex + 1, fragmentIndex) : uri.substring(queryIndex + 1);
        } else {
            int fragmentIndex = uri.indexOf(35);
            this.path = fragmentIndex != -1 ? uri.substring(0, fragmentIndex) : uri;
        }
    }

    @Override
    public HttpServerRequest body(Handler<AsyncResult<Buffer>> handler) {
        this.delegate.body(handler);
        return this;
    }

    @Override
    public DecoderResult decoderResult() {
        return this.delegate.decoderResult();
    }

    @Override
    public Future<Buffer> body() {
        return this.delegate.body();
    }

    @Override
    public long bytesRead() {
        return this.delegate.bytesRead();
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)handler);
        return this;
    }

    @Override
    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler((Handler)handler);
        return this;
    }

    @Override
    public HttpVersion version() {
        return this.delegate.version();
    }

    @Override
    public HttpMethod method() {
        if (!this.modified) {
            return this.delegate.method();
        }
        return this.method;
    }

    @Override
    public String uri() {
        if (!this.modified) {
            return this.delegate.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (!this.modified) {
            return this.delegate.path();
        }
        return this.path;
    }

    @Override
    public String query() {
        if (!this.modified) {
            return this.delegate.query();
        }
        return this.query;
    }

    @Override
    public MultiMap params() {
        if (!this.modified) {
            return this.delegate.params();
        }
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder;
            Map<String, List<String>> prms;
            this.params = MultiMap.caseInsensitiveMultiMap();
            if (this.query != null && !(prms = (queryStringDecoder = new QueryStringDecoder(this.uri, Charset.forName(this.delegate.getParamsCharset()))).parameters()).isEmpty()) {
                for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                    this.params.add(entry.getKey(), (Iterable<String>)entry.getValue());
                }
            }
        }
        return this.params;
    }

    @Override
    public String getParam(String param) {
        if (!this.modified) {
            return this.delegate.getParam(param);
        }
        return this.params().get(param);
    }

    @Override
    public HttpServerResponse response() {
        return this.delegate.response();
    }

    @Override
    public MultiMap headers() {
        return this.delegate.headers();
    }

    @Override
    public String getHeader(String s) {
        return this.delegate.getHeader(s);
    }

    @Override
    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    @Override
    public HttpServerRequest setParamsCharset(String s) {
        String old = this.delegate.getParamsCharset();
        this.delegate.setParamsCharset(s);
        if (!s.equals(old)) {
            this.params = null;
        }
        return this;
    }

    @Override
    public String getParamsCharset() {
        return this.delegate.getParamsCharset();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.forwardedParser.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    @Override
    @Deprecated
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    @Override
    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    @Override
    public String absoluteURI() {
        if (!this.modified) {
            return this.forwardedParser.absoluteURI();
        }
        if (this.absoluteURI == null) {
            String scheme = this.forwardedParser.scheme();
            String host = this.forwardedParser.host();
            this.absoluteURI = scheme != null && host != null ? scheme + "://" + host + this.uri : this.uri;
        }
        return this.absoluteURI;
    }

    @Override
    public String scheme() {
        return this.forwardedParser.scheme();
    }

    @Override
    public String host() {
        return this.forwardedParser.host();
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.delegate.connection();
    }

    @Override
    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        return this;
    }

    @Override
    public void toNetSocket(Handler<AsyncResult<NetSocket>> handler) {
        this.delegate.toNetSocket(handler);
    }

    @Override
    public Future<NetSocket> toNetSocket() {
        return this.delegate.toNetSocket();
    }

    @Override
    public HttpServerRequest setExpectMultipart(boolean b) {
        this.delegate.setExpectMultipart(b);
        return this;
    }

    @Override
    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        return this;
    }

    @Override
    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    @Override
    public String getFormAttribute(String s) {
        return this.delegate.getFormAttribute(s);
    }

    @Override
    public int streamId() {
        return this.delegate.streamId();
    }

    @Override
    public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        this.delegate.toWebSocket(toWebSocket -> {
            if (toWebSocket.succeeded()) {
                handler.handle(Future.succeededFuture(new ServerWebSocketWrapper((ServerWebSocket)toWebSocket.result(), this.host(), this.scheme(), this.isSSL(), this.remoteAddress())));
            } else {
                handler.handle((AsyncResult<ServerWebSocket>)toWebSocket);
            }
        });
    }

    @Override
    public Future<ServerWebSocket> toWebSocket() {
        return this.delegate.toWebSocket().map(ws -> new ServerWebSocketWrapper((ServerWebSocket)ws, this.host(), this.scheme(), this.isSSL(), this.remoteAddress()));
    }

    @Override
    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    @Override
    public boolean isSSL() {
        return this.forwardedParser.isSSL();
    }

    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    @Override
    public StreamPriority streamPriority() {
        return this.delegate.streamPriority();
    }

    @Override
    public @Nullable Cookie getCookie(String name) {
        return this.delegate.getCookie(name);
    }

    @Override
    public @Nullable Cookie getCookie(String name, String domain, String path) {
        return this.delegate.getCookie(name, domain, path);
    }

    @Override
    public String getParam(String paramName, String defaultValue) {
        return this.delegate.getParam(paramName, defaultValue);
    }

    @Override
    public Set<Cookie> cookies(String name) {
        return this.delegate.cookies(name);
    }

    @Override
    public Set<Cookie> cookies() {
        return this.delegate.cookies();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public Future<Void> end() {
        return this.delegate.end();
    }

    @Override
    public HttpServerRequest routed(String route) {
        this.delegate.routed(route);
        return this;
    }

    @Override
    public Context context() {
        return this.delegate.context();
    }

    @Override
    public Object metric() {
        return this.delegate.metric();
    }

    @Override
    public Pipe<Buffer> pipe() {
        return this.delegate.pipe();
    }

    @Override
    public Future<Void> pipeTo(WriteStream<Buffer> dst) {
        return this.delegate.pipeTo(dst);
    }

    @Override
    public void pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst, handler);
    }
}

