/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.graph;

import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.NodeFilterIGraphEdgeIterable;

public interface IGraphNode {
    public Object getId();

    public Set<String> getPropertyKeys();

    public Object getProperty(String var1);

    public void setProperty(String var1, Object var2);

    public Iterable<IGraphEdge> getEdges();

    default public Iterable<IGraphEdge> getEdges(Iterable<IGraphNode> nodes) {
        return new NodeFilterIGraphEdgeIterable(this.getEdges(), nodes, 3);
    }

    public Iterable<IGraphEdge> getEdgesWithType(String var1);

    default public Iterable<IGraphEdge> getEdgesWithType(String type, Iterable<IGraphNode> nodes) {
        return new NodeFilterIGraphEdgeIterable(this.getEdgesWithType(type), nodes, 3);
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String var1);

    default public Iterable<IGraphEdge> getOutgoingWithType(String type, Iterable<IGraphNode> endNodes) {
        return new NodeFilterIGraphEdgeIterable(this.getOutgoingWithType(type), endNodes, 2);
    }

    public Iterable<IGraphEdge> getIncomingWithType(String var1);

    default public Iterable<IGraphEdge> getIncomingWithType(String type, Iterable<IGraphNode> startNodes) {
        return new NodeFilterIGraphEdgeIterable(this.getIncomingWithType(type), startNodes, 1);
    }

    public Iterable<IGraphEdge> getIncoming();

    default public Iterable<IGraphEdge> getIncoming(Iterable<IGraphNode> startNodes) {
        return new NodeFilterIGraphEdgeIterable(this.getIncoming(), startNodes, 1);
    }

    public Iterable<IGraphEdge> getOutgoing();

    default public Iterable<IGraphEdge> getOutgoing(Iterable<IGraphNode> endNodes) {
        return new NodeFilterIGraphEdgeIterable(this.getOutgoing(), endNodes, 2);
    }

    public void delete();

    public boolean equals(Object var1);

    public IGraphDatabase getGraph();

    public void removeProperty(String var1);
}

