/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.backend.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hawk.backend.tests.BackendTestSuite;
import org.eclipse.hawk.backend.tests.LogbackOnlyErrorsRule;
import org.eclipse.hawk.backend.tests.RedirectSystemErrorRule;
import org.eclipse.hawk.backend.tests.TemporaryDatabaseTest;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class GraphPopulationTest
extends TemporaryDatabaseTest {
    @Rule
    public RedirectSystemErrorRule errRule = new RedirectSystemErrorRule();
    @Rule
    public LogbackOnlyErrorsRule logRule = new LogbackOnlyErrorsRule();

    @Parameterized.Parameters(name="Parameters are {0}")
    public static Iterable<Object[]> params() {
        return BackendTestSuite.caseParams();
    }

    public GraphPopulationTest(IGraphDatabaseFactory dbFactory) {
        super(dbFactory);
    }

    @Test
    public void oneNode() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.allNodes("eobject").size());
                n = this.db.createNode(new HashMap(), "eobject");
                Assert.assertEquals((long)1L, (long)this.db.allNodes("eobject").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n2 = this.db.getNodeById(n.getId());
                Assert.assertEquals((String)"equals() should be implemented", (Object)n, (Object)n2);
                Assert.assertEquals((String)"hashCode() should be implemented", (long)n.hashCode(), (long)n2.hashCode());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void oneNodeProperty() throws Exception {
        Object propValue;
        IGraphNode n;
        IGraphIterable eobs;
        IGraphTransaction tx;
        String sValue = "hello world";
        String esValue = "";
        boolean bValue = true;
        double dValue = 1.34;
        float fValue = 3.3f;
        Object[] asValue = new String[]{"a", "b"};
        double[] adValue = new double[]{1.1, 2.3};
        float[] afValue = new float[]{1.1f, 2.3f};
        long[] alValue = new long[]{1L, 2L};
        short[] sArray = new short[4];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        short[] ahValue = sArray;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] aiValue = nArray;
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byte[] abValue = byArray;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Throwable throwable = null;
        Object var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                eobs = this.db.allNodes("eobject");
                Assert.assertEquals((long)0L, (long)eobs.size());
                map.put("d", 1.34);
                map.put("f", Float.valueOf(3.3f));
                map.put("s", "hello world");
                map.put("es", "");
                map.put("b", true);
                map.put("as", asValue);
                map.put("ad", adValue);
                map.put("af", afValue);
                map.put("al", alValue);
                map.put("ai", aiValue);
                map.put("ah", ahValue);
                map.put("ab", abValue);
                n = this.db.createNode(map, "eobject");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals(map.keySet(), (Object)n.getPropertyKeys());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode node = (IGraphNode)eobs.getSingle();
                Assert.assertEquals((double)1.34, (double)((Double)node.getProperty("d")), (double)Double.MIN_NORMAL);
                Assert.assertEquals((long)1L, (long)eobs.size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.setProperty("d", (Object)2.57);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((double)2.57, (double)((Double)((IGraphNode)eobs.getSingle()).getProperty("d")), (double)Double.MIN_NORMAL);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.setProperty("d", null);
                Assert.assertFalse((boolean)n.getPropertyKeys().stream().anyMatch(key -> "d".equals(key)));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((float)3.3f, (float)((Number)((IGraphNode)eobs.getSingle()).getProperty("f")).floatValue(), (float)Float.MIN_NORMAL);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.removeProperty("s");
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((Object)"hello world", (Object)((IGraphNode)eobs.getSingle()).getProperty("s"));
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable10) {
            if (throwable == null) {
                throwable = throwable10;
            } else if (throwable != throwable10) {
                throwable.addSuppressed(throwable10);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.removeProperty("s");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable11) {
            if (throwable == null) {
                throwable = throwable11;
            } else if (throwable != throwable11) {
                throwable.addSuppressed(throwable11);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertNull((Object)((IGraphNode)eobs.getSingle()).getProperty("s"));
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable12) {
            if (throwable == null) {
                throwable = throwable12;
            } else if (throwable != throwable12) {
                throwable.addSuppressed(throwable12);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((Object)"", (Object)n.getProperty("es"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable13) {
            if (throwable == null) {
                throwable = throwable13;
            } else if (throwable != throwable13) {
                throwable.addSuppressed(throwable13);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((Object)true, (Object)((IGraphNode)eobs.getSingle()).getProperty("b"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable14) {
            if (throwable == null) {
                throwable = throwable14;
            } else if (throwable != throwable14) {
                throwable.addSuppressed(throwable14);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("as");
                Assert.assertArrayEquals((Object[])asValue, (Object[])((String[])propValue));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable15) {
            if (throwable == null) {
                throwable = throwable15;
            } else if (throwable != throwable15) {
                throwable.addSuppressed(throwable15);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("ad");
                Assert.assertArrayEquals((double[])adValue, (double[])((double[])propValue), (double)0.01);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable16) {
            if (throwable == null) {
                throwable = throwable16;
            } else if (throwable != throwable16) {
                throwable.addSuppressed(throwable16);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("af");
                Assert.assertArrayEquals((float[])afValue, (float[])((float[])propValue), (float)0.01f);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable17) {
            if (throwable == null) {
                throwable = throwable17;
            } else if (throwable != throwable17) {
                throwable.addSuppressed(throwable17);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("al");
                Assert.assertArrayEquals((long[])alValue, (long[])((long[])propValue));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable18) {
            if (throwable == null) {
                throwable = throwable18;
            } else if (throwable != throwable18) {
                throwable.addSuppressed(throwable18);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("ah");
                Assert.assertArrayEquals((short[])ahValue, (short[])((short[])propValue));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable19) {
            if (throwable == null) {
                throwable = throwable19;
            } else if (throwable != throwable19) {
                throwable.addSuppressed(throwable19);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("ai");
                Assert.assertArrayEquals((int[])aiValue, (int[])((int[])propValue));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable20) {
            if (throwable == null) {
                throwable = throwable20;
            } else if (throwable != throwable20) {
                throwable.addSuppressed(throwable20);
            }
            throw throwable;
        }
        throwable = null;
        var18_35 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                propValue = ((IGraphNode)eobs.getSingle()).getProperty("ab");
                Assert.assertArrayEquals((byte[])abValue, (byte[])((byte[])propValue));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable21) {
            if (throwable == null) {
                throwable = throwable21;
            } else if (throwable != throwable21) {
                throwable.addSuppressed(throwable21);
            }
            throw throwable;
        }
    }

    @Test
    public void oneNodeBatch() throws Exception {
        this.db.enterBatchMode();
        String idValue = "http://foo.bar";
        char[] invalidChars = ":,; %=".toCharArray();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("id", "http://foo.bar");
        char[] cArray = invalidChars;
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            char invalidChar = cArray[n2];
            props.put("my" + invalidChar + "value", String.valueOf(invalidChar));
            ++n2;
        }
        IGraphNode n3 = this.db.createNode(props, "metamodel");
        Assert.assertEquals(props.keySet(), (Object)n3.getPropertyKeys());
        for (Map.Entry entry : props.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)n3.getProperty((String)entry.getKey()));
        }
        this.db.exitBatchMode();
        Throwable throwable = null;
        Iterator iterator = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            Assert.assertEquals((long)1L, (long)this.db.allNodes("metamodel").size());
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void oneNodeRollback() throws Exception {
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.allNodes("metamodel").size());
                this.db.createNode(new HashMap(), "metamodel");
                Assert.assertEquals((long)1L, (long)this.db.allNodes("metamodel").size());
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.allNodes("metamodel").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void oneNodeRemove() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.allNodes("eobject").size());
                n = this.db.createNode(null, "eobject");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.allNodes("eobject").size());
                n.delete();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.db.allNodes("eobject").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void oneNodeRemoveRollback() throws Exception {
        IGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (IGraphTransaction tx2 = this.db.beginTransaction();){
            Assert.assertEquals((long)0L, (long)this.db.allNodes("eobject").size());
            tx2.success();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable2 = null;
        Object var3_9 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n = this.db.createNode(null, "eobject");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        throwable2 = null;
        var3_9 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.allNodes("eobject").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable2 == null) {
                throwable2 = throwable5;
            } else if (throwable2 != throwable5) {
                throwable2.addSuppressed(throwable5);
            }
            throw throwable2;
        }
        throwable2 = null;
        var3_9 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.delete();
                tx.failure();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        throwable2 = null;
        var3_9 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.db.allNodes("eobject").size());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable2 == null) {
                throwable2 = throwable7;
            } else if (throwable2 != throwable7) {
                throwable2.addSuppressed(throwable7);
            }
            throw throwable2;
        }
    }

    @Test
    public void twoNodesBatch() throws Exception {
        this.db.enterBatchMode();
        IGraphNode x1 = this.db.createNode(Collections.singletonMap("x", 1), "eobject");
        IGraphNode x10 = this.db.createNode(Collections.singletonMap("x", 10), "eobject");
        IGraphEdge e1 = this.db.createRelationship(x1, x10, "dep", Collections.singletonMap("y", "abc"));
        this.db.createRelationship(x1, x10, "light", null);
        this.db.exitBatchMode();
        Throwable throwable = null;
        Object var5_6 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            Assert.assertEquals((Object)1, (Object)e1.getStartNode().getProperty("x"));
            Assert.assertEquals((Object)10, (Object)e1.getEndNode().getProperty("x"));
            Assert.assertEquals((Object)"abc", (Object)e1.getProperty("y"));
            Assert.assertEquals((Object)"dep", (Object)e1.getType());
            Assert.assertEquals((long)1L, (long)this.size(x1.getOutgoingWithType("light")));
            Assert.assertEquals((long)1L, (long)this.size(x1.getOutgoingWithType("light", Collections.singleton(x10))));
            Assert.assertEquals((long)1L, (long)this.size(x10.getIncomingWithType("light")));
            Assert.assertEquals((long)1L, (long)this.size(x10.getIncomingWithType("light", Collections.singleton(x1))));
            Assert.assertEquals((long)1L, (long)this.size(x1.getOutgoingWithType("dep")));
            Assert.assertEquals((long)1L, (long)this.size(x1.getOutgoingWithType("dep", Collections.singleton(x10))));
            Assert.assertEquals((long)1L, (long)this.size(x10.getIncomingWithType("dep")));
            Assert.assertEquals((long)1L, (long)this.size(x10.getIncomingWithType("dep", Collections.singleton(x1))));
            Assert.assertEquals((long)0L, (long)this.size(x10.getIncomingWithType("other")));
            Assert.assertEquals((long)0L, (long)this.size(x10.getIncomingWithType("other", Collections.singleton(x1))));
            Assert.assertTrue((boolean)e1.getPropertyKeys().contains("y"));
            e1.removeProperty("y");
            Assert.assertFalse((boolean)e1.getPropertyKeys().contains("y"));
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void recreateEdge() throws Exception {
        IGraphNode x10;
        IGraphNode x1;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                x1 = this.db.createNode(Collections.singletonMap("x", 1), "eobject");
                x10 = this.db.createNode(Collections.singletonMap("x", 10), "eobject");
                IGraphEdge e1 = this.db.createRelationship(x1, x10, "dep");
                e1.delete();
                this.db.createRelationship(x1, x10, "dep");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)1L, (long)this.size(x1.getOutgoingWithType("dep")));
                Assert.assertEquals((long)1L, (long)this.size(x10.getIncomingWithType("dep")));
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void duplicateEdge() throws Exception {
        Throwable throwable = null;
        Object var4_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            IGraphNode a = this.db.createNode(Collections.singletonMap("label", "a"), "eobject");
            IGraphNode b = this.db.createNode(Collections.singletonMap("label", "b"), "eobject");
            Assert.assertNotNull((Object)this.db.createRelationship(a, b, "rel"));
            Assert.assertNotNull((Object)this.db.createRelationship(a, b, "rel"));
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void twoNodesBatchRemoveRel() throws Exception {
        this.db.enterBatchMode();
        IGraphNode x1 = this.db.createNode(Collections.singletonMap("x", 1), "eobject");
        IGraphNode x10 = this.db.createNode(Collections.singletonMap("x", 10), "eobject");
        IGraphEdge e = this.db.createRelationship(x1, x10, "dep", Collections.singletonMap("y", "abc"));
        this.db.exitBatchMode();
        try {
            this.db.enterBatchMode();
            e.delete();
            this.db.exitBatchMode();
        }
        catch (IllegalStateException ex) {
            Assume.assumeTrue((String)"Backend does not allow deletion during batch mode", (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.size(x1.getOutgoingWithType("dep")));
        Assert.assertEquals((long)0L, (long)this.size(x10.getIncomingWithType("dep")));
    }

    @Test
    public void threeNodesRemoveMiddle() throws Exception {
        IGraphNode right;
        IGraphNode middle;
        IGraphNode left;
        IGraphTransaction tx;
        String edgeType = "x";
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                left = this.db.createNode(null, "eobject");
                middle = this.db.createNode(null, "eobject");
                right = this.db.createNode(null, "eobject");
                this.db.createRelationship(left, middle, "x", null);
                this.db.createRelationship(middle, right, "x", Collections.singletonMap("some", "thing"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.size(left.getIncoming()));
                Assert.assertEquals((long)0L, (long)this.size(left.getIncoming(Arrays.asList(middle, right))));
                Assert.assertEquals((long)1L, (long)this.size(left.getOutgoing()));
                Assert.assertEquals((long)1L, (long)this.size(left.getOutgoing(Arrays.asList(middle))));
                Assert.assertEquals((long)1L, (long)this.size(left.getEdges()));
                Assert.assertEquals((long)1L, (long)this.size(left.getEdges(Arrays.asList(middle))));
                Assert.assertEquals((long)1L, (long)this.size(middle.getIncoming()));
                Assert.assertEquals((long)1L, (long)this.size(middle.getIncoming(Arrays.asList(left))));
                Assert.assertEquals((long)1L, (long)this.size(middle.getOutgoing()));
                Assert.assertEquals((long)1L, (long)this.size(middle.getOutgoing(Arrays.asList(right))));
                Assert.assertEquals((long)2L, (long)this.size(middle.getEdges()));
                Assert.assertEquals((long)2L, (long)this.size(middle.getEdges(Arrays.asList(left, right))));
                Assert.assertEquals((long)2L, (long)this.size(middle.getEdgesWithType("x")));
                Assert.assertEquals((long)2L, (long)this.size(middle.getEdgesWithType("x", Arrays.asList(left, right))));
                Assert.assertEquals((long)1L, (long)this.size(right.getIncoming()));
                Assert.assertEquals((long)1L, (long)this.size(right.getIncoming(Collections.singleton(middle))));
                Assert.assertEquals((long)0L, (long)this.size(right.getOutgoing()));
                Assert.assertEquals((long)0L, (long)this.size(right.getOutgoing(Arrays.asList(left, middle))));
                Assert.assertEquals((long)1L, (long)this.size(right.getEdges()));
                Assert.assertEquals((long)1L, (long)this.size(right.getEdges(Collections.singleton(middle))));
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var6_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                middle.delete();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var6_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals((long)0L, (long)this.size(left.getIncoming()));
                Assert.assertEquals((long)0L, (long)this.size(left.getOutgoing()));
                Assert.assertEquals((long)0L, (long)this.size(left.getEdges()));
                Assert.assertEquals((long)0L, (long)this.size(left.getEdgesWithType("x")));
                Assert.assertEquals((long)0L, (long)this.size(right.getIncoming()));
                Assert.assertEquals((long)0L, (long)this.size(right.getOutgoing()));
                Assert.assertEquals((long)0L, (long)this.size(right.getEdges()));
                Assert.assertEquals((long)0L, (long)this.size(right.getEdgesWithType("x")));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    @Test
    public void escapeInvalidClassCharacters() throws Exception {
        char[] invalidClassChars;
        char[] cArray = invalidClassChars = ":,; %@=.".toCharArray();
        int n = invalidClassChars.length;
        int n2 = 0;
        while (n2 < n) {
            char invalidChar = cArray[n2];
            Throwable throwable = null;
            Object var7_8 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                String nodeType = "my" + invalidChar + "object";
                this.db.createNode(null, nodeType);
                Assert.assertEquals((String)("There should be one node of type " + nodeType), (long)1L, (long)this.db.allNodes(nodeType).size());
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
    }

    @Test
    public void escapeInvalidCharactersEdges() throws Exception {
        char[] invalidClassChars;
        IGraphNode n2;
        IGraphNode n1;
        Throwable throwable = null;
        Object var4_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            n1 = this.db.createNode(null, "eobject");
            n2 = this.db.createNode(null, "eobject");
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        char[] cArray = invalidClassChars = ":,; %@=.".toCharArray();
        int n = invalidClassChars.length;
        int n3 = 0;
        while (n3 < n) {
            char invalidChar = cArray[n3];
            String type = "link" + invalidChar + "type";
            Throwable throwable3 = null;
            Object var10_15 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                this.db.createRelationship(n1, n2, type, Collections.singletonMap("test", "t"));
                Iterable allOut = n1.getOutgoingWithType(type);
                Assert.assertEquals((String)("There should be one outgoing " + type + " edge for n1"), (long)1L, (long)this.size(allOut));
                Iterable allIn = n2.getIncomingWithType(type);
                Assert.assertEquals((String)("There should be one incoming " + type + " edge for n2"), (long)1L, (long)this.size(allIn));
                tx.success();
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            ++n3;
        }
    }

    @Test
    public void escapeInvalidFieldCharacters() throws Exception {
        char[] invalidClassChars;
        IGraphNode n1;
        Throwable throwable = null;
        Object var3_3 = null;
        try (IGraphTransaction tx = this.db.beginTransaction();){
            n1 = this.db.createNode(null, "eobject");
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        char[] cArray = invalidClassChars = ":,; %@=.".toCharArray();
        int n = invalidClassChars.length;
        int n2 = 0;
        while (n2 < n) {
            char invalidChar = cArray[n2];
            Throwable throwable3 = null;
            Object var8_13 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                String propName = "x" + invalidChar + "a";
                n1.setProperty(propName, (Object)1);
                Assert.assertEquals((String)("Property " + propName + " should have been set"), (Object)1, (Object)n1.getProperty(propName));
                Assert.assertTrue((String)("Property " + propName + " should be one of the keys"), (boolean)n1.getPropertyKeys().contains(propName));
                n1.removeProperty(propName);
                Assert.assertFalse((String)("Property " + propName + " should have been removed"), (boolean)n1.getPropertyKeys().contains(propName));
                tx.success();
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            ++n2;
        }
    }

    private <T> int size(Iterable<T> it) {
        Iterator<T> iterator = it.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

