/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirtyDerivedFeaturesListener
implements IGraphChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirtyDerivedFeaturesListener.class);
    public static final String NOT_YET_DERIVED_PREFIX = "_NYD##";
    private final Set<IGraphNode> nodesToBeUpdated = new HashSet<IGraphNode>();
    private IGraphDatabase db;
    private Set<IGraphNode> markedForRemoval = new HashSet<IGraphNode>();
    private Set<Map.Entry<String, String>> pending = new HashSet<Map.Entry<String, String>>();

    public DirtyDerivedFeaturesListener(IGraphDatabase graph) {
        this.db = graph;
    }

    public Set<IGraphNode> getNodesToBeUpdated() {
        this.resolvePending();
        this.nodesToBeUpdated.removeAll(this.markedForRemoval);
        return this.nodesToBeUpdated;
    }

    private void resolvePending() {
        HashSet<IGraphNode> toBeUpdated = new HashSet<IGraphNode>();
        try {
            IGraphNodeIndex idx;
            IGraphIterable anyResults;
            IGraphTransaction t = null;
            if (this.db.currentMode().equals((Object)IGraphDatabase.Mode.TX_MODE)) {
                t = this.db.beginTransaction();
            }
            if ((anyResults = (idx = this.db.getOrCreateNodeIndex("derivedaccessdictionary")).query("*", (Object)"*")).iterator().hasNext()) {
                for (Map.Entry<String, String> e : this.pending) {
                    for (IGraphNode n : idx.query(e.getKey(), (Object)e.getValue())) {
                        toBeUpdated.add(n);
                    }
                }
            }
            if (toBeUpdated.size() > 0) {
                if (t == null) {
                    t = this.db.beginTransaction();
                }
                for (IGraphNode n : toBeUpdated) {
                    this.markDependentToBeUpdated(n);
                }
            }
            if (t != null) {
                t.success();
                t.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Marking of derived attributes needing update failed", (Throwable)e);
        }
        this.pending.clear();
    }

    public String getName() {
        return "Internal Listener For Finding Dirty Attributes";
    }

    public void synchroniseStart() {
    }

    public void synchroniseEnd() {
    }

    public void changeStart() {
    }

    public void changeSuccess() {
    }

    public void changeFailure() {
        this.nodesToBeUpdated.clear();
        this.pending.clear();
    }

    public void metamodelAddition(IHawkPackage pkg, IGraphNode pkgNode) {
    }

    public void classAddition(IHawkClass cls, IGraphNode clsNode) {
    }

    public void fileAddition(VcsCommitItem s, IGraphNode fileNode) {
    }

    public void fileRemoval(VcsCommitItem s, IGraphNode fileNode) {
    }

    public void modelElementAddition(VcsCommitItem s, IHawkObject element, IGraphNode elementNode, boolean isTransient) {
        if (!isTransient) {
            this.markDependentToBeUpdated(elementNode.getId().toString());
        }
    }

    public void modelElementRemoval(VcsCommitItem s, IGraphNode elementNode, boolean isTransient) {
        if (!isTransient) {
            this.markDependentToBeUpdated(elementNode.getId().toString());
        } else {
            this.markForRemoval(elementNode);
        }
    }

    private void markForRemoval(IGraphNode elementNode) {
        this.markedForRemoval.add(elementNode);
    }

    private Map.Entry<String, String> createEntry(String k, String v) {
        PendingEntry ret = new PendingEntry(k, v);
        return ret;
    }

    public void modelElementAttributeUpdate(VcsCommitItem s, IHawkObject eObject, String attrName, Object oldValue, Object newValue, IGraphNode elementNode, boolean isTransient) {
        if (!isTransient) {
            this.pending.add(this.createEntry(elementNode.getId().toString(), attrName));
        }
    }

    public void modelElementAttributeRemoval(VcsCommitItem s, IHawkObject eObject, String attrName, IGraphNode node, boolean isTransient) {
        if (!isTransient) {
            this.pending.add(this.createEntry(node.getId().toString(), attrName));
        }
    }

    public void referenceAddition(VcsCommitItem s, IGraphNode source, IGraphNode destination, String edgelabel, boolean isTransient) {
        if (!isTransient) {
            this.pending.add(this.createEntry(source.getId().toString(), edgelabel));
        }
    }

    public void referenceRemoval(VcsCommitItem s, IGraphNode source, IGraphNode destination, String edgelabel, boolean isTransient) {
        if (!isTransient) {
            this.pending.add(this.createEntry(source.getId().toString(), edgelabel));
        }
    }

    private void markDependentToBeUpdated(String key) {
        this.pending.add(this.createEntry(key, "*"));
    }

    private void markDependentToBeUpdated(IGraphNode node) {
        Iterable incoming = node.getIncoming();
        IGraphEdge firstIncoming = (IGraphEdge)incoming.iterator().next();
        String derivedPropertyName = firstIncoming.getType();
        node.setProperty(derivedPropertyName, (Object)(NOT_YET_DERIVED_PREFIX + node.getProperty("derivationlogic")));
        this.nodesToBeUpdated.add(node);
    }

    public void setModelIndexer(IModelIndexer m) {
    }

    private final class PendingEntry
    implements Map.Entry<String, String> {
        String key;
        String value;

        public PendingEntry(String k, String v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public int hashCode() {
            int prime = 29;
            int result = Integer.MIN_VALUE;
            result += this.key.hashCode() * 29 ^ 1;
            return result += this.value.hashCode() * 29 ^ 2;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                return ((Map.Entry)o).getKey().equals(this.key) && ((Map.Entry)o).getValue().equals(this.value);
            }
            return false;
        }

        public String toString() {
            return "PendingEntry [key=" + this.key + ", value=" + this.value + "]";
        }
    }
}

