/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.server.users.servlet.db;

import java.io.Serializable;
import java.util.Calendar;

public class User
implements Serializable {
    private static final long serialVersionUID = -8897748864090665228L;
    private String username;
    private String hashedPassword;
    private Calendar expirationDate;
    private boolean isAdmin;
    private String realName;

    public User() {
    }

    public User(User copyFrom) {
        this.username = copyFrom.username;
        this.hashedPassword = copyFrom.hashedPassword;
        this.expirationDate = copyFrom.expirationDate;
        this.isAdmin = copyFrom.isAdmin;
        this.realName = copyFrom.realName;
    }

    public static Builder builder(User copyFrom) {
        return new Builder(new User(copyFrom));
    }

    public static Builder builder() {
        return new Builder(new User());
    }

    public String getUsername() {
        return this.username;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getRealName() {
        return this.realName;
    }

    public static class Builder {
        private User user;

        private Builder(User u) {
            this.user = u;
        }

        public User build() {
            User ret = this.user;
            this.user = null;
            return ret;
        }

        public Builder username(String s) {
            this.user.username = s;
            return this;
        }

        public Builder hashedPassword(String s) {
            this.user.hashedPassword = s;
            return this;
        }

        public Builder expirationDate(Calendar c) {
            this.user.expirationDate = c;
            return this;
        }

        public Builder isAdmin(boolean b) {
            this.user.isAdmin = b;
            return this;
        }

        public Builder realName(String s) {
            this.user.realName = s;
            return this;
        }
    }
}

