/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security;

import java.lang.reflect.Field;
import java.security.PrivilegedExceptionAction;
import org.jboss.weld.security.GetDeclaredFieldAction;

public class FieldLookupAction
extends GetDeclaredFieldAction
implements PrivilegedExceptionAction<Field> {
    public FieldLookupAction(Class<?> javaClass, String fieldName) {
        super(javaClass, fieldName);
    }

    @Override
    public Field run() throws NoSuchFieldException {
        return FieldLookupAction.lookupField(this.javaClass, this.fieldName);
    }

    public static Field lookupField(Class<?> javaClass, String fieldName) throws NoSuchFieldException {
        for (Class<?> inspectedClass = javaClass; inspectedClass != null; inspectedClass = inspectedClass.getSuperclass()) {
            for (Class<?> inspectedInterface : inspectedClass.getInterfaces()) {
                try {
                    return FieldLookupAction.lookupField(inspectedInterface, fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            try {
                return inspectedClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException();
    }
}

