/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.glassfish.api.invocation.ResourceHandler;

public class SimpleEjbResourceHandlerImpl
implements ResourceHandler,
Synchronization {
    private static Map<Transaction, SimpleEjbResourceHandlerImpl> _resourceHandlers = new ConcurrentHashMap<Transaction, SimpleEjbResourceHandlerImpl>();
    private List l = null;
    private Transaction tx = null;
    private TransactionManager tm = null;

    private SimpleEjbResourceHandlerImpl(TransactionManager tm) {
        this.tm = tm;
        this.checkTransaction();
    }

    public static ResourceHandler createResourceHandler(TransactionManager tm) {
        return new SimpleEjbResourceHandlerImpl(tm);
    }

    public static ResourceHandler getResourceHandler(TransactionManager tm) {
        SimpleEjbResourceHandlerImpl rh = null;
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                rh = _resourceHandlers.get(tx);
            }
        }
        catch (Exception e) {
            BaseContainer._logger.log(Level.WARNING, "Exception during Singleton ResourceHandler processing", e);
        }
        if (rh == null) {
            rh = new SimpleEjbResourceHandlerImpl(tm);
        }
        return rh;
    }

    public List getResourceList() {
        if (this.tx == null) {
            this.checkTransaction();
        }
        if (this.l == null) {
            this.l = new ArrayList();
        }
        return this.l;
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCompletion(int status) {
        if (this.tx != null) {
            _resourceHandlers.remove(this.tx);
            this.tx = null;
        }
    }

    private void checkTransaction() {
        try {
            this.tx = this.tm.getTransaction();
            if (this.tx != null) {
                this.tx.registerSynchronization(this);
                _resourceHandlers.put(this.tx, this);
            }
        }
        catch (Exception e) {
            this.tx = null;
            BaseContainer._logger.log(Level.WARNING, "Exception during Singleton ResourceHandler processing", e);
        }
    }
}

