/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.webui.jsf.util.LogUtil;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.component.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIComponentELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        this.log("getValue(ctx, " + base + "," + property + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            this.log("argument is null or not of applicable type. returning");
            return null;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        UIComponent kid = (UIComponent)component.getFacets().get(id);
        if (kid != null) {
            context.setPropertyResolved(true);
            this.log("returning facet " + kid);
            return kid;
        }
        if (component.getChildCount() < 1) {
            this.log("child count less than 1. returning");
            return null;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            context.setPropertyResolved(true);
            this.log("returning child " + kid);
            return kid;
        }
        this.log("can't resolve. returning");
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        this.log("setValue(ctx, " + base + "," + property + "," + value + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null || value == null || !(value instanceof UIComponent)) {
            this.log("argument is null or not of applicable type. returning");
            return;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            component.getFacets().put(id, (UIComponent)value);
            context.setPropertyResolved(true);
            this.log("set facet");
            return;
        }
        if (component.getChildCount() < 1) {
            this.log("child count less than 1. returning");
            return;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            kids.set(i, value);
            context.setPropertyResolved(true);
            this.log("set child");
            return;
        }
        this.log("can't resolve. returning");
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        this.log("isReadOnly(ctx, " + base + "," + property + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            this.log("argument is null or not of applicable type. returning");
            return false;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            context.setPropertyResolved(true);
            this.log("not read-only. found facet");
            return false;
        }
        if (component.getChildCount() < 1) {
            this.log("child count less than 1. returning");
            return false;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            context.setPropertyResolved(true);
            this.log("not read-only. found child");
            return false;
        }
        this.log("can't resolve. returning");
        return false;
    }

    public Class getType(ELContext context, Object base, Object property) {
        this.log("getType(ctx, " + base + "," + property + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || !(base instanceof UIComponent) || property == null) {
            this.log("argument is null or not of applicable type. returning");
            return null;
        }
        UIComponent component = (UIComponent)base;
        String id = property.toString();
        if (component.getFacets().get(id) != null) {
            context.setPropertyResolved(true);
            this.log("found facet. returning UIComponent.class");
            return UIComponent.class;
        }
        if (component.getChildCount() < 1) {
            this.log("child count less than 1. returning");
            return null;
        }
        List kids = component.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            UIComponent kid = (UIComponent)kids.get(i);
            if (!id.equals(kid.getId())) continue;
            context.setPropertyResolved(true);
            this.log("found child. returning UIComponent.class");
            return UIComponent.class;
        }
        this.log("can't resolve. returning");
        return null;
    }

    private void log(String message) {
        if (LogUtil.finestEnabled(UIComponentELResolver.class)) {
            LogUtil.finest(UIComponentELResolver.class, message);
        }
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        this.log("getFeatureDescriptors(ctx, " + base + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return Arrays.asList(new FeatureDescriptor[0]).iterator();
        }
        if (!(base instanceof UIComponent)) {
            return null;
        }
        ArrayList<FeatureDescriptor> result = new ArrayList<FeatureDescriptor>();
        UIComponent baseUic = (UIComponent)base;
        Iterator facetsAndChildren = baseUic.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent kid = (UIComponent)facetsAndChildren.next();
            FeatureDescriptor desc = new FeatureDescriptor();
            String kidId = kid.getId();
            desc.setName(kidId);
            desc.setDisplayName(kidId);
            desc.setValue("type", String.class);
            desc.setValue("resolvableAtDesignTime", true);
            result.add(desc);
        }
        return result.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        this.log("getCommonPropertyType(ctx, " + base + ")");
        if (context == null) {
            throw new NullPointerException();
        }
        if (!(base instanceof UIComponent)) {
            return null;
        }
        return String.class;
    }
}

