/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.impl.AbstractDataProvider;
import com.sun.data.provider.impl.ObjectFieldKeySupport;
import java.beans.Beans;
import java.util.ResourceBundle;

public class ObjectDataProvider
extends AbstractDataProvider {
    private transient ResourceBundle bundle = null;
    private boolean includeFields = true;
    private Object object;
    private transient ObjectFieldKeySupport support = null;

    public ObjectDataProvider() {
        this(null, false);
    }

    public ObjectDataProvider(Object object) {
        this(object, false);
    }

    public ObjectDataProvider(Object object, boolean includeFields) {
        this.includeFields = includeFields;
        this.setObject(object);
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
        this.support = null;
    }

    public boolean isIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(boolean includeFields) {
        this.includeFields = includeFields;
        this.support = null;
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        FieldKey fieldKey = null;
        if (this.getSupport() != null) {
            fieldKey = this.getSupport().getFieldKey(fieldId);
        }
        if (fieldKey != null) {
            return fieldKey;
        }
        throw new IllegalArgumentException(fieldId);
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.getSupport() != null) {
            return this.getSupport().getFieldKeys();
        }
        return FieldKey.EMPTY_ARRAY;
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        return this.getSupport().getType(fieldKey);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        if (Beans.isDesignTime() && this.object == null) {
            this.object = AbstractDataProvider.getFakeData(this.object.getClass());
        }
        return this.getSupport().getValue(fieldKey, this.object);
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        if (this.getSupport().isReadOnly(fieldKey)) {
            throw new IllegalStateException(fieldKey.toString() + " " + this.getBundle().getString("IS_READ_ONLY"));
        }
        Object previous = this.getSupport().getValue(fieldKey, this.object);
        this.getSupport().setValue(fieldKey, this.object, value);
        this.fireValueChanged(fieldKey, previous, value);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        return this.getSupport().isReadOnly(fieldKey);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    private ObjectFieldKeySupport getSupport() {
        if (this.support == null && this.object != null) {
            this.support = new ObjectFieldKeySupport(this.object.getClass(), this.includeFields);
        }
        return this.support;
    }
}

