/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.util;

import java.util.Enumeration;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.eclipse.gemini.blueprint.test.internal.holder.OsgiTestInfoHolder;

public abstract class TestUtils {
    public static TestResult cloneTestResults(OsgiTestInfoHolder source, TestResult destination, Test test) {
        Iterator iter = source.getTestErrors().iterator();
        while (iter.hasNext()) {
            destination.addError(test, (Throwable)iter.next());
        }
        for (Throwable originalFailure : source.getTestFailures()) {
            AssertionFailedError clonedFailure = new AssertionFailedError(originalFailure.getMessage());
            clonedFailure.setStackTrace(originalFailure.getStackTrace());
            destination.addFailure(test, clonedFailure);
        }
        return destination;
    }

    public static void unpackProblems(TestResult result, OsgiTestInfoHolder holder) {
        Enumeration errors = result.errors();
        while (errors.hasMoreElements()) {
            TestFailure failure = (TestFailure)errors.nextElement();
            holder.addTestError(failure.thrownException());
        }
        Enumeration failures = result.failures();
        while (failures.hasMoreElements()) {
            TestFailure failure = (TestFailure)failures.nextElement();
            holder.addTestFailure(failure.thrownException());
        }
    }
}

