/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class PropertiesUtil {
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final Properties EMPTY_PROPERTIES = new Properties();

    public static Properties loadAndExpand(Resource resource) {
        OrderedProperties props = new OrderedProperties();
        if (resource == null) {
            return props;
        }
        try {
            props.load(resource.getInputStream());
        }
        catch (IOException ex) {
            return null;
        }
        return PropertiesUtil.expandProperties(props);
    }

    public static Properties filterKeysStartingWith(Properties properties, String prefix) {
        if (!StringUtils.hasText((String)prefix)) {
            return EMPTY_PROPERTIES;
        }
        Assert.notNull((Object)properties);
        Properties excluded = properties instanceof OrderedProperties ? new OrderedProperties() : new Properties();
        Enumeration<Object> enm = properties.keys();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(prefix)) continue;
            excluded.put(key, properties.get(key));
        }
        enm = excluded.keys();
        while (enm.hasMoreElements()) {
            properties.remove(enm.nextElement());
        }
        return excluded;
    }

    public static Properties filterValuesStartingWith(Properties properties, String prefix) {
        if (!StringUtils.hasText((String)prefix)) {
            return EMPTY_PROPERTIES;
        }
        Assert.notNull((Object)properties);
        Properties excluded = properties instanceof OrderedProperties ? new OrderedProperties() : new Properties();
        Enumeration<Object> enm = properties.keys();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            String value = properties.getProperty(key);
            if (!value.startsWith(prefix)) continue;
            excluded.put(key, value);
        }
        enm = excluded.keys();
        while (enm.hasMoreElements()) {
            properties.remove(enm.nextElement());
        }
        return excluded;
    }

    public static Properties expandProperties(Properties props) {
        Assert.notNull((Object)props);
        Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
        Properties newProps = props instanceof OrderedProperties ? new OrderedProperties() : new Properties();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String resultKey = PropertiesUtil.expandProperty(key, props);
            String resultValue = PropertiesUtil.expandProperty(value, props);
            newProps.put(resultKey, resultValue);
        }
        return newProps;
    }

    private static String expandProperty(String prop, Properties properties) throws IllegalArgumentException {
        boolean hasPlaceholder = false;
        String copy = prop;
        StringBuilder result = new StringBuilder();
        int index = 0;
        do {
            if ((index = copy.indexOf(DELIM_START)) >= 0) {
                hasPlaceholder = true;
                result.append(copy.substring(0, index));
                copy = copy.substring(index + DELIM_START.length());
                int stopIndex = copy.indexOf(DELIM_STOP);
                String token = null;
                if (stopIndex >= 0) {
                    token = copy.substring(0, stopIndex);
                    copy = copy.substring(stopIndex + 1);
                    result.append(properties.getProperty(token));
                    continue;
                }
                throw new IllegalArgumentException("cannot interpret property " + prop + " due of token [" + copy + "]");
            }
            hasPlaceholder = false;
            result.append(copy);
        } while (hasPlaceholder);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrderedProperties
    extends Properties
    implements Cloneable {
        private final Map<Object, Object> map = new LinkedHashMap<Object, Object>();

        private OrderedProperties() {
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.map).equals(o);
        }

        @Override
        public Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public String getProperty(String key) {
            Object oval = this.map.get(key);
            String sval = oval instanceof String ? (String)oval : null;
            return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
        }

        @Override
        public int hashCode() {
            return ((Object)this.map).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<Object> keySet() {
            return this.map.keySet();
        }

        @Override
        public Object put(Object key, Object value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> m) {
            this.map.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public synchronized boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            return new IteratorBackedEnumeration<Object>(this.map.values().iterator());
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return new IteratorBackedEnumeration<Object>(this.map.keySet().iterator());
        }

        @Override
        public synchronized String toString() {
            return this.map.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class IteratorBackedEnumeration<K>
        implements Enumeration<K> {
            private final Iterator<? extends K> iterator;

            public IteratorBackedEnumeration(Iterator<? extends K> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public K nextElement() {
                return this.iterator.next();
            }
        }
    }
}

