/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.mm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RequestDirection implements Enumerator
{
    UNSPECIFIED(0, "UNSPECIFIED", "UNSPECIFIED"),
    REQUEST(1, "REQUEST", "REQUEST"),
    RESPONSE(2, "RESPONSE", "RESPONSE"),
    REQUESTRESPONSE(3, "REQUESTRESPONSE", "REQUESTRESPONSE");

    public static final int UNSPECIFIED_VALUE = 0;
    public static final int REQUEST_VALUE = 1;
    public static final int RESPONSE_VALUE = 2;
    public static final int REQUESTRESPONSE_VALUE = 3;
    private static final RequestDirection[] VALUES_ARRAY;
    public static final List<RequestDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequestDirection[]{UNSPECIFIED, REQUEST, RESPONSE, REQUESTRESPONSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequestDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequestDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequestDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequestDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequestDirection get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED;
            }
            case 1: {
                return REQUEST;
            }
            case 2: {
                return RESPONSE;
            }
            case 3: {
                return REQUESTRESPONSE;
            }
        }
        return null;
    }

    private RequestDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

