/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.mm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataflowDirection implements Enumerator
{
    UNSPECIFIED(0, "UNSPECIFIED", "UNSPECIFIED"),
    DEFAULT(1, "DEFAULT", "DEFAULT"),
    OTHER(2, "OTHER", "OTHER");

    public static final int UNSPECIFIED_VALUE = 0;
    public static final int DEFAULT_VALUE = 1;
    public static final int OTHER_VALUE = 2;
    private static final DataflowDirection[] VALUES_ARRAY;
    public static final List<DataflowDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataflowDirection[]{UNSPECIFIED, DEFAULT, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataflowDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataflowDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataflowDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataflowDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataflowDirection get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED;
            }
            case 1: {
                return DEFAULT;
            }
            case 2: {
                return OTHER;
            }
        }
        return null;
    }

    public static DataflowDirection getOpposite(DataflowDirection direction) {
        switch (direction) {
            case OTHER: {
                return DEFAULT;
            }
            case DEFAULT: {
                return OTHER;
            }
            case UNSPECIFIED: {
                return UNSPECIFIED;
            }
        }
        return UNSPECIFIED;
    }

    private DataflowDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

