/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.mm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AccessType implements Enumerator
{
    UNSPECIFIED(0, "UNSPECIFIED", "UNSPECIFIED"),
    READ(1, "READ", "READ"),
    WRITE(2, "WRITE", "WRITE"),
    RW(3, "RW", "RW");

    public static final int UNSPECIFIED_VALUE = 0;
    public static final int READ_VALUE = 1;
    public static final int WRITE_VALUE = 2;
    public static final int RW_VALUE = 3;
    private static final AccessType[] VALUES_ARRAY;
    public static final List<AccessType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AccessType[]{UNSPECIFIED, READ, WRITE, RW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AccessType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AccessType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AccessType get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED;
            }
            case 1: {
                return READ;
            }
            case 2: {
                return WRITE;
            }
            case 3: {
                return RW;
            }
        }
        return null;
    }

    private AccessType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

