/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.extensionpoint;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESExtensionElement {
    private final IConfigurationElement element;
    private boolean exceptionInsteadOfNull;

    public ESExtensionElement(IConfigurationElement element) {
        this(element, false);
    }

    public ESExtensionElement(IConfigurationElement element, boolean throwExceptions) {
        this.element = element;
        this.exceptionInsteadOfNull = throwExceptions;
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        String attribute = this.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(attribute);
    }

    public Integer getInteger(String name) {
        try {
            return Integer.parseInt(this.getAttribute(name));
        }
        catch (NumberFormatException e) {
            return (Integer)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, e, Messages.ESExtensionPoint_ValueNotFound);
        }
    }

    public String getAttribute(String name) {
        String attribute = this.element.getAttribute(name);
        if (attribute == null) {
            ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
        }
        return attribute;
    }

    public <T> T getClass(String classAttributeName, Class<T> returnType) {
        try {
            Object executableExtension = this.element.createExecutableExtension(classAttributeName);
            if (returnType.isInstance(executableExtension)) {
                return (T)executableExtension;
            }
            return (T)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
        }
        catch (CoreException e) {
            return (T)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, (Exception)((Object)e), Messages.ESExtensionPoint_ValueNotFound);
        }
    }

    public IConfigurationElement getIConfigurationElement() {
        return this.element;
    }

    public void setThrowException(boolean throwException) {
        this.exceptionInsteadOfNull = throwException;
    }

    public boolean getThrowException() {
        return this.exceptionInsteadOfNull;
    }
}

