/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.spore.options.CompactionStrategy;
import org.eclipse.elk.alg.spore.options.RootSelection;
import org.eclipse.elk.alg.spore.options.SpanningTreeCostFunction;
import org.eclipse.elk.alg.spore.options.SporeCompactionOptions;
import org.eclipse.elk.alg.spore.options.SporeOverlapRemovalOptions;
import org.eclipse.elk.alg.spore.options.StructureExtractionStrategy;
import org.eclipse.elk.alg.spore.options.TreeConstructionStrategy;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class SporeMetaDataProvider
implements ILayoutMetaDataProvider {
    public static final IProperty<String> UNDERLYING_LAYOUT_ALGORITHM = new Property("org.eclipse.elk.underlyingLayoutAlgorithm");
    private static final StructureExtractionStrategy STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY_DEFAULT = StructureExtractionStrategy.DELAUNAY_TRIANGULATION;
    public static final IProperty<StructureExtractionStrategy> STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY = new Property("org.eclipse.elk.structure.structureExtractionStrategy", (Object)STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY_DEFAULT, null, null);
    private static final TreeConstructionStrategy PROCESSING_ORDER_TREE_CONSTRUCTION_DEFAULT = TreeConstructionStrategy.MINIMUM_SPANNING_TREE;
    public static final IProperty<TreeConstructionStrategy> PROCESSING_ORDER_TREE_CONSTRUCTION = new Property("org.eclipse.elk.processingOrder.treeConstruction", (Object)PROCESSING_ORDER_TREE_CONSTRUCTION_DEFAULT, null, null);
    private static final SpanningTreeCostFunction PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION_DEFAULT = SpanningTreeCostFunction.CIRCLE_UNDERLAP;
    public static final IProperty<SpanningTreeCostFunction> PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION = new Property("org.eclipse.elk.processingOrder.spanningTreeCostFunction", (Object)PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION_DEFAULT, null, null);
    private static final String PROCESSING_ORDER_PREFERRED_ROOT_DEFAULT = null;
    public static final IProperty<String> PROCESSING_ORDER_PREFERRED_ROOT = new Property("org.eclipse.elk.processingOrder.preferredRoot", (Object)PROCESSING_ORDER_PREFERRED_ROOT_DEFAULT, null, null);
    private static final RootSelection PROCESSING_ORDER_ROOT_SELECTION_DEFAULT = RootSelection.CENTER_NODE;
    public static final IProperty<RootSelection> PROCESSING_ORDER_ROOT_SELECTION = new Property("org.eclipse.elk.processingOrder.rootSelection", (Object)PROCESSING_ORDER_ROOT_SELECTION_DEFAULT, null, null);
    private static final CompactionStrategy COMPACTION_COMPACTION_STRATEGY_DEFAULT = CompactionStrategy.DEPTH_FIRST;
    public static final IProperty<CompactionStrategy> COMPACTION_COMPACTION_STRATEGY = new Property("org.eclipse.elk.compaction.compactionStrategy", (Object)COMPACTION_COMPACTION_STRATEGY_DEFAULT, null, null);
    private static final boolean COMPACTION_ORTHOGONAL_DEFAULT = false;
    public static final IProperty<Boolean> COMPACTION_ORTHOGONAL = new Property("org.eclipse.elk.compaction.orthogonal", (Object)false, null, null);
    private static final int OVERLAP_REMOVAL_MAX_ITERATIONS_DEFAULT = 64;
    public static final IProperty<Integer> OVERLAP_REMOVAL_MAX_ITERATIONS = new Property("org.eclipse.elk.overlapRemoval.maxIterations", (Object)64, null, null);
    private static final boolean OVERLAP_REMOVAL_RUN_SCANLINE_DEFAULT = true;
    public static final IProperty<Boolean> OVERLAP_REMOVAL_RUN_SCANLINE = new Property("org.eclipse.elk.overlapRemoval.runScanline", (Object)true, null, null);
    private static final RootSelection PROCESSING_ORDER_PREFERRED_ROOT_DEP_PROCESSING_ORDER_ROOT_SELECTION_0 = RootSelection.FIXED;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.underlyingLayoutAlgorithm").group("").name("Underlying Layout Algorithm").description("A layout algorithm that is applied to the graph before it is compacted. If this is null, nothing is applied before compaction.").type(LayoutOptionData.Type.STRING).optionClass(String.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.structure.structureExtractionStrategy").group("structure").name("Structure Extraction Strategy").description("This option defines what kind of triangulation or other partitioning of the plane is applied to the vertices.").defaultValue((Object)STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(StructureExtractionStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.processingOrder.treeConstruction").group("processingOrder").name("Tree Construction Strategy").description("Whether a minimum spanning tree or a maximum spanning tree should be constructed.").defaultValue((Object)PROCESSING_ORDER_TREE_CONSTRUCTION_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(TreeConstructionStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.processingOrder.spanningTreeCostFunction").group("processingOrder").name("Cost Function for Spanning Tree").description("The cost function is used in the creation of the spanning tree.").defaultValue((Object)PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(SpanningTreeCostFunction.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.processingOrder.preferredRoot").group("processingOrder").name("Root node for spanning tree construction").description("The identifier of the node that is preferred as the root of the spanning tree. If this is null, the first node is chosen.").defaultValue((Object)PROCESSING_ORDER_PREFERRED_ROOT_DEFAULT).type(LayoutOptionData.Type.STRING).optionClass(String.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.addDependency("org.eclipse.elk.processingOrder.preferredRoot", "org.eclipse.elk.processingOrder.rootSelection", (Object)PROCESSING_ORDER_PREFERRED_ROOT_DEP_PROCESSING_ORDER_ROOT_SELECTION_0);
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.processingOrder.rootSelection").group("processingOrder").name("Root selection for spanning tree").description("This sets the method used to select a root node for the construction of a spanning tree").defaultValue((Object)PROCESSING_ORDER_ROOT_SELECTION_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(RootSelection.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.compaction.compactionStrategy").group("compaction").name("Compaction Strategy").description("This option defines how the compaction is applied.").defaultValue((Object)COMPACTION_COMPACTION_STRATEGY_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(CompactionStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.compaction.orthogonal").group("compaction").name("Orthogonal Compaction").description("Restricts the translation of nodes to orthogonal directions in the compaction phase.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.overlapRemoval.maxIterations").group("overlapRemoval").name("Upper limit for iterations of overlap removal").description(null).defaultValue((Object)64).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.overlapRemoval.runScanline").group("overlapRemoval").name("Whether to run a supplementary scanline overlap check.").description(null).defaultValue((Object)true).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        new SporeOverlapRemovalOptions().apply(registry);
        new SporeCompactionOptions().apply(registry);
    }
}

